/*
 * gtksaneprogressbar.h: Fix brokenness in GtkProgressBar
 * David Maze <dmaze@mit.edu>
 * $Id: gtksaneprogressbar.h,v 1.1 2000/02/02 00:36:29 dmaze Exp $
 */

#ifndef __GTKSANEPROGRESSBAR_H__
#define __GTKSANEPROGRESSBAR_H__

#include <gtk/gtk.h>

#define GTK_SANE_PROGRESS_BAR(obj) GTK_CHECK_CAST((obj), \
  gtk_sane_progress_bar_get_type(), GtkSaneProgressBar)
#define GTK_SANE_PROGRESS_BAR_CLASS(klass) GTK_CHECK_CLASS_CAST((klass), \
  gtk_sane_progress_bar_get_type(), GtkSaneProgressBarClass)
#define IS_GTK_SANE_PROGRESS_BAR(obj) GTK_CHECK_TYPE((obj), \
  gtk_sane_progress_bar_get_type())

typedef struct _GtkSaneProgressBarClass GtkSaneProgressBarClass;
typedef struct _GtkSaneProgressBar GtkSaneProgressBar;

struct _GtkSaneProgressBarClass
{
  GtkProgressBarClass parent_class;
};

struct _GtkSaneProgressBar
{
  GtkProgressBar progress_bar;
};

GtkType gtk_sane_progress_bar_get_type(void);
GtkWidget *gtk_sane_progress_bar_new(void);

#endif /* __GTKSANEPROGRESSBAR_H__ */
