/*
 * gtkxznola.h: The main xznola window
 * David Maze <dmaze@mit.edu>
 * $Id: gtkxznola.h,v 1.2 1999/10/10 23:45:06 dmaze Exp $
 */

#ifndef _GTKXZNOLA_H
#define _GTKXZNOLA_H

#include <gtk/gtk.h>

#include "gtkanyone.h"

struct gtk_xznola;
typedef struct gtk_xznola gtk_xznola;

/* gtk_xznola is the main window for the xznola application.  It can have
 * zero or one GtkAnyone objects bound to it, if such an object is bound,
 * it will be shown. */

gtk_xznola *gtk_xznola_new();
/*  effects: Creates a new main window with nothing bound. */

void gtk_xznola_delete(gtk_xznola *xznola);
/* modifies: xznola
 *  effects: Destroys xznola. */

GtkAnyone *gtk_xznola_get_anyone(const gtk_xznola *xznola);
/*  effects: Returns the GtkAnyone object bound to xznola, or NULL if none
 *           is bound. */

GtkAnyone *gtk_xznola_bind_anyone(gtk_xznola *xznola, GtkAnyone *anyone);
/* modifies: xznola
 *  effects: Binds anyone to xznola, and unbinds whatever was previously
 *           bound.  Returns the GtkAnyone that was previously bound, if
 *           any. */

GtkAnyone *gtk_xznola_unbind_anyone(gtk_xznola *xznola);
/* modifies: xznola
 *  effects: Removes a binding from xznola.  Returns what was previously
 *           bound, if anything. */

GtkAnyone *gtk_xznola_open_anyone(gtk_xznola *xznola, GString *filename);
/* modifies: xznola
 *  effects: Attempts to open filename as a .anyone file.  If it succeeds,
 *           bind the resulting GtkAnyone object and return what was
 *           previously bound.  If it fails, return NULL. */

void gtk_xznola_close_anyone(gtk_xznola *xznola);
/* modifies: xznola
 *  effects: Unbinds and frees the currently bound GtkAnyone object. */

GtkWidget *gtk_xznola_window(const gtk_xznola *xznola);
/*  effects: Returns the main window of xznola. */

void gtk_xznola_update(gtk_xznola *xznola);
/*  effects: Updates the bound GtkAnyone of xznola, if any. */

#endif /* _GTKXZNOLA_H */
