/*
 * anyone.h: Read special spluftified .anyone files
 * David Maze <dmaze@mit.edu>
 * $Id: anyone.h,v 1.1 1999/04/11 15:16:52 dmaze Exp $
 */

#ifndef __ANYONE_H
#define __ANYONE_H

#include <glib.h>
#include "zgroup.h"

zgroup *read_anyone(const GString *filename);
/*  effects: Reads the file named in filename, and returns a zgroup for
 *           the top of the group tree described there. */

zgroup *read_anyone_default(void);
/*  effects: Reads the file named in $ANYONE, or from .anyone in the user's
 *           home directory, and returns a zgroup for the top of the group
 *           tree described there. */

GString *default_anyone(void);
/*  effects: Returns the name of the default .anyone file, namely the value
 *           of $ANYONE, if defined, or .anyone in the user's home
 *           directory. */

#endif /* __ANYONE_H */
