/*
 * newxznola.c: The new improved xznola
 * David Maze <dmaze@mit.edu>
 * $Id: xznola.c,v 1.4 1999/10/10 23:50:34 dmaze Exp $
 * (As if this will ever see CVS)
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "zgroup.h"
#include "anyone.h"
#include "gtkanyone.h"
#include "gtkxznola.h"

gint main_delete(GtkWidget *widget, GdkEventAny *event);

/* Given this, we can do some UI mucking. */
static void do_file_open(GString *file);
/* modifies: curfile (static), window (static)
 *  effects: Closes the current file, if any, and opens a new one.
 *           Completely updates the UI. */

static void do_file_close();
/* modifies: curfile (static), window (static)
 *  effects: Closes the current file, if any, and removes it from the UI. */

/* Some of the UI needs this information.  *sigh* */
static GtkAnyone *curfile;
static gtk_xznola *xznola;

int main(int argc, char **argv)
{
  GString *file;

  ZInitialize();
  gtk_init(&argc, &argv);

  xznola = gtk_xznola_new();

  /* We want to exit when the main window is externally deleted. */
  gtk_signal_connect(GTK_OBJECT(gtk_xznola_window(xznola)), "delete_event",
		     GTK_SIGNAL_FUNC(main_delete), NULL);

  /* Show the main window now so the transient-window stuff works. */
  gtk_widget_show(gtk_xznola_window(xznola));
  
  /* Open the default .anyone file. */
  curfile = NULL;
  file = default_anyone();
  do_file_open(file);
  g_string_free(file, TRUE);
  
  gtk_main();
  return 0;
}

gint main_delete(GtkWidget *widget, GdkEventAny *event)
{
  gtk_main_quit();
}

static void do_file_open(GString *file)
{
  GtkAnyone *anyone = GTK_ANYONE(gtk_anyone_open(file));
  
  /* If the open failed, don't do anything; just leave the existing UI up. */
  if (!anyone)
    return;
  
  /* Otherwise close the old UI and set up the new one. */
  gtk_xznola_bind_anyone(xznola, anyone);
  gtk_xznola_update(xznola);
  curfile = anyone;
  gtk_widget_show(GTK_WIDGET(curfile));  
}

static void do_file_close()
{
  /* If we don't have a file open, don't do anything. */
  if (!curfile)
    return;

  /* Clean up everything. */
  gtk_widget_destroy(GTK_WIDGET(curfile));
  curfile = NULL;
}

