/*
 * gtkzuseritem.h: GtkTreeItem subclass for displaying users
 * David Maze <dmaze@mit.edu>
 * $Id: gtkzuseritem.h,v 1.1 2001/11/18 22:22:08 dmaze Exp $
 */

#ifndef __GTKZUSERITEM_H__
#define __GTKZUSERITEM_H__

#include <gtk/gtk.h>
#include "zuser.h"

#define GTK_ZUSER_ITEM(obj) \
  GTK_CHECK_CAST((obj), gtk_zuser_item_get_type(), GtkZUserItem)
#define GTK_ZUSER_ITEM_CLASS(klass) GTK_CHECK_CLASS_CAST((klass), \
  gtk_zuser_item_get_type(), GtkZUserItemClass)
#define IS_GTK_ZUSER_ITEM(obj) \
  GTK_CHECK_TYPE((obj), gtk_zuser_item_get_type())

typedef struct _GtkZUserItemClass GtkZUserItemClass;
typedef struct _GtkZUserItem GtkZUserItem;

struct _GtkZUserItemClass
{
  GtkTreeItemClass parent_class;
};

struct _GtkZUserItem
{
  GtkTreeItem tree_item;
  
  zuser *user;
};

GtkType gtk_zuser_item_get_type(void);
GtkWidget *gtk_zuser_item_new(zuser *user);
zuser *gtk_zuser_item_user(const GtkZUserItem *item);
void gtk_zuser_item_construct(GtkZUserItem *item, zuser *user);

#endif /* __GTKZUSERITEM_H__ */
