/*
 * gtkzgroupitem.c: GtkTreeItem subclass for displaying groups
 * David Maze <dmaze@mit.edu>
 * $Id: gtkzgroupitem.c,v 1.1 2001/11/18 21:54:27 dmaze Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gtkzgroupitem.h"

static void gtk_zgroup_item_class_init(GtkZGroupItemClass *klass);
static void gtk_zgroup_item_init(GtkZGroupItem *item);

static void gtk_zgroup_item_class_init(GtkZGroupItemClass *klass)
{
}

static void gtk_zgroup_item_init(GtkZGroupItem *item)
{
  item->group = NULL;
}

GtkType gtk_zgroup_item_get_type(void)
{
  static GtkType item_type = 0;
  
  if (!item_type)
  {
    static const GtkTypeInfo item_info =
      {
        "GtkZGroupItem",
        sizeof(GtkZGroupItem),
        sizeof(GtkZGroupItemClass),
        (GtkClassInitFunc) gtk_zgroup_item_class_init,
        (GtkObjectInitFunc) gtk_zgroup_item_init,
        NULL,
        NULL,
        (GtkClassInitFunc) NULL
      };
    item_type = gtk_type_unique(gtk_tree_item_get_type(), &item_info);
  }
  
  return item_type;
}

GtkWidget *gtk_zgroup_item_new(zgroup *group)
{
  GtkWidget *item;
  
  g_return_val_if_fail(group != NULL, NULL);
  
  item = gtk_type_new(gtk_zgroup_item_get_type());
  gtk_zgroup_item_construct(GTK_ZGROUP_ITEM(item), group);
  return item;
}

void gtk_zgroup_item_construct(GtkZGroupItem *item, zgroup *group)
{
  GtkWidget *label;
  GString *name;
  
  g_return_if_fail(item != NULL);
  g_return_if_fail(group != NULL);
  
  item->group = group;

  /* Statically create the child label, based on the visible group name. */
  name = zgroup_label(group);
  label = gtk_label_new(name->str);
  g_string_free(name, TRUE);
  gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
  gtk_container_add(GTK_CONTAINER(item), label);
  gtk_widget_show(label);
}

zgroup *gtk_zgroup_item_group(const GtkZGroupItem *item)
{
  g_return_val_if_fail(item != NULL, NULL);
  return item->group;
}
