/*
 * gtkzgroupitem.h: GtkTreeItem subclass for displaying groups
 * David Maze <dmaze@mit.edu>
 * $Id: gtkzgroupitem.h,v 1.1 2001/11/18 21:54:28 dmaze Exp $
 */

#ifndef __GTKZGROUPITEM_H__
#define __GTKZGROUPITEM_H__

#include <gtk/gtk.h>
#include "zgroup.h"

#define GTK_ZGROUP_ITEM(obj) \
  GTK_CHECK_CAST((obj), gtk_zgroup_item_get_type(), GtkZGroupItem)
#define GTK_ZGROUP_ITEM_CLASS(klass) GTK_CHECK_CLASS_CAST((klass), \
  gtk_zgroup_item_get_type(), GtkZGroupItemClass)
#define IS_GTK_ZGROUP_ITEM(obj) \
  GTK_CHECK_TYPE((obj), gtk_zgroup_item_get_type())

typedef struct _GtkZGroupItemClass GtkZGroupItemClass;
typedef struct _GtkZGroupItem GtkZGroupItem;

struct _GtkZGroupItemClass
{
  GtkTreeItemClass parent_class;
};

struct _GtkZGroupItem
{
  GtkTreeItem tree_item;
  
  zgroup *group;
};

GtkType gtk_zgroup_item_get_type(void);
GtkWidget *gtk_zgroup_item_new(zgroup *group);
zgroup *gtk_zgroup_item_group(const GtkZGroupItem *item);
void gtk_zgroup_item_construct(GtkZGroupItem *item, zgroup *group);

#endif /* __GTKZGROUPITEM_H__ */
