/*
 * gtkzuseritem.c: GtkTreeItem subclass for displaying users
 * David Maze <dmaze@mit.edu>
 * $Id: gtkzuseritem.c,v 1.1 2001/11/18 22:22:07 dmaze Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gtkzuseritem.h"

static void gtk_zuser_item_class_init(GtkZUserItemClass *klass);
static void gtk_zuser_item_init(GtkZUserItem *item);

static void gtk_zuser_item_class_init(GtkZUserItemClass *klass)
{
}

static void gtk_zuser_item_init(GtkZUserItem *item)
{
  item->user = NULL;
}

GtkType gtk_zuser_item_get_type(void)
{
  static GtkType item_type = 0;
  
  if (!item_type)
  {
    static const GtkTypeInfo item_info =
      {
        "GtkZUserItem",
        sizeof(GtkZUserItem),
        sizeof(GtkZUserItemClass),
        (GtkClassInitFunc) gtk_zuser_item_class_init,
        (GtkObjectInitFunc) gtk_zuser_item_init,
        NULL,
        NULL,
        (GtkClassInitFunc) NULL
      };
    item_type = gtk_type_unique(gtk_tree_item_get_type(), &item_info);
  }
  
  return item_type;
}

GtkWidget *gtk_zuser_item_new(zuser *user)
{
  GtkWidget *item;
  
  g_return_val_if_fail(user != NULL, NULL);
  
  item = gtk_type_new(gtk_zuser_item_get_type());
  gtk_zuser_item_construct(GTK_ZUSER_ITEM(item), user);
  return item;
}

void gtk_zuser_item_construct(GtkZUserItem *item, zuser *user)
{
  GtkWidget *label;
  GString *name;
  
  g_return_if_fail(item != NULL);
  g_return_if_fail(user != NULL);
  
  item->user = user;

  /* Statically create the child label, based on the visible user name. */
  name = zuser_name(user);
  label = gtk_label_new(name->str);
  g_string_free(name, TRUE);
  gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
  gtk_container_add(GTK_CONTAINER(item), label);
  gtk_widget_show(label);
}

zuser *gtk_zuser_item_user(const GtkZUserItem *item)
{
  g_return_val_if_fail(item != NULL, NULL);
  return item->user;
}
