/*
 * zuser.h: Describe a single user
 * David Maze <dmaze@mit.edu>
 * $Id: zuser.h,v 1.3 2001/12/11 04:06:41 dmaze Exp $
 */

#ifndef __ZUSER_H
#define __ZUSER_H

#include <glib.h>

#ifdef HAVE_ZEPHYR_ZEPHYR_H
#include <zephyr/zephyr.h>
#else
#error "Need zephyr/zephyr.h to compile"
#endif

typedef struct _zuser zuser;

/* A zuser contains information about a particular user.  It contains a
 * printable name and a fully-qualified Kerberos principal.  It also
 * may contain a cached list of known locations for the user. */

zuser *zuser_new(const GString *name);
/*  effects: Returns a new zuser named name.  If it contains an @ sign,
 *           the name is the part to the left of the @ sign, and the
 *           principal is the full name.  Otherwise, the name parameter
 *           is the name, and the principal is this extended with the
 *           default realm. */

void zuser_delete(zuser *user);
/*  effects: Destroys user. */

GString *zuser_name(const zuser *user);
/*  effects: Returns the name of user, without a realm. */

GString *zuser_principal(const zuser *user);
/*  effects: Returns the full Kerberos principal of user (with a realm). */

void zuser_update(zuser *user);
/* modifies: user
 *  effects: Queries the Zephyr servers to find out where, if anywhere, user
 *           is. */

int zuser_count_locs(const zuser *user);
/*  effects: Returns the number of locations user is visible at, if any. */

const ZLocations_t *zuser_get_loc(const zuser *user, int n);
/* requires: 0 <= n < zuser_count_locs(user)
 *  effects: Returns the nth (zero-based) location the user is visible at. */

#endif /* __ZUSER_H */
