/*
 * zusertable.h: A table mapping usernames to user objects
 * David Maze <dmaze@mit.edu>
 * $Id: zusertable.h,v 1.3 1999/10/05 14:47:57 dmaze Exp $
 */

#ifndef __ZUSERTABLE_H
#define __ZUSERTABLE_H

#include <glib.h>
#include "zuser.h"

typedef struct _zusertable zusertable;
/* A zusertable contains a mapping of usernames to zuser objects.  A given
 * name/object pair will only be in the table once. */

typedef void (*zuseriter)(zuser *user, gpointer data);
/* A zuseriter is a function that can be used to iterate over zuser
 * objects. */

zusertable *zusertable_new();
/*  effects: Returns a new empty zusertable. */

void zusertable_delete(zusertable *table);
/*  effects: Destroys table. */

zuser *zusertable_add(zusertable *table, GString *name, zuser *user);
/*  effects: Adds a mapping from name to user to table, if no mapping for
 *           name already exists; has no effect otherwise. Claims ownership
 *           of user.  Returns user if the mapping is successfully added,
 *           or the binding already in the table if not.  Destroys user
 *           if another mapping is already in the table.
 * modifies: table, user */

zuser *zusertable_add_new(zusertable *table, GString *name);
/*  effects: Adds a mapping from name to a new zuser object, if no mapping
 *           for name already exists; has no effect otherwise.  Returns
 *           the new user object, or whatever is already in the table.
 * modifies: table */

GString *zusertable_remove(zusertable *table, GString *name);
/*  effects: Removes any mapping for name in table.  Has no effect if name
 *           is not in table.
 * modifies: table */

zuser *zusertable_lookup(zusertable *table, GString *name);
/*  effects: Returns the zuser name maps to in table, or NULL if there is
 *           no such mapping.  table continues to own the returned user. */

void zusertable_foreach(zusertable *table, zuseriter iter, gpointer data);
/*  effects: Calls iter once for each user in table, with data as a
 *           parameter. */

int zusertable_count(const zusertable *table);
/*  effects: Returns the number of users in table. */

#endif /* __ZUSERTABLE_H */
