/*
 * gtksaneprogressbar.c: Fix brokenness in GtkProgressBar
 * David Maze <dmaze@mit.edu>
 * $Id: gtksaneprogressbar.c,v 1.1 2000/02/02 00:36:00 dmaze Exp $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gtksaneprogressbar.h"

/* WHINE BITCH AND MOAN TIME!
 *
 * "So, David, what do you really want to do?"  "I want a
 * GtkProgressBar that's narrower than 150 pixels wide.  Let's make
 * it, say, 20 pixels wide."
 *
 * This should be easy, right?  A peek at gtkprogressbar.c in the Gtk+
 * source shows that we just need to override the parent's size_request
 * function.  (And now that I've figured out what it does, I could reduce
 * everything I actually wanted to do to about 10 lines of code, were
 * this in, say, C++ or Java.)  But Gtk+ can't be that simple, can it?
 * I need to:
 *
 * -- Redeclare every argument in my parent class in my class_init function.
 * -- Reimplement my parent's set_arg and get_arg method, since a late
 *    initializer method for GtkObject brilliantly writes zeros in after
 *    the GtkProgressBar class_init happens.
 * -- Copy some constants out of my parent, and pray they never change
 *    upstream.
 *
 * Grr.
 */

/* Local function prototypes */
static void gtk_sane_progress_bar_class_init(GtkSaneProgressBarClass *klass);
static void gtk_sane_progress_bar_init(GtkSaneProgressBar *bar);
static void gtk_sane_progress_bar_size_request(GtkWidget *widget,
					       GtkRequisition *requisition);
static void gtk_sane_progress_bar_set_arg(GtkObject *object, GtkArg *arg,
					  guint arg_id);
static void gtk_sane_progress_bar_get_arg(GtkObject *object, GtkArg *arg,
					  guint arg_id);


/* Constants we've tweaked.  These do pretty much the intuitively
 * obvious thing, we think. */
#define MIN_HORIZONTAL_BAR_WIDTH   20
#define MIN_HORIZONTAL_BAR_HEIGHT  20
#define MIN_VERTICAL_BAR_WIDTH     20
#define MIN_VERTICAL_BAR_HEIGHT    20
#define MAX_TEXT_LENGTH            80
#define TEXT_SPACING               2

/* Constants we've gratuitously copied from the parent class. */
enum {
  ARG_0,
  ARG_ADJUSTMENT,
  ARG_ORIENTATION,
  ARG_BAR_STYLE,
  ARG_ACTIVITY_STEP,
  ARG_ACTIVITY_BLOCKS,
  ARG_DISCRETE_BLOCKS
};

static void gtk_sane_progress_bar_class_init(GtkSaneProgressBarClass *klass)
{
  /* The point of this is to get a not-broken size_request function.
   * Fix that. */
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  
  object_class = (GtkObjectClass *)klass;
  widget_class = (GtkWidgetClass *)klass;

  /* So it looks like every child class needs to redeclare its parent's
   * arguments, or else things potentially lose badly.  *sigh* */
  gtk_object_add_arg_type ("GtkSaneProgressBar::adjustment",
			   GTK_TYPE_ADJUSTMENT,
			   GTK_ARG_READWRITE | GTK_ARG_CONSTRUCT,
			   ARG_ADJUSTMENT);
  gtk_object_add_arg_type ("GtkSaneProgressBar::orientation",
			   GTK_TYPE_PROGRESS_BAR_ORIENTATION,
			   GTK_ARG_READWRITE,
			   ARG_ORIENTATION);
  gtk_object_add_arg_type ("GtkSaneProgressBar::bar_style",
			   GTK_TYPE_PROGRESS_BAR_STYLE,
			   GTK_ARG_READWRITE,
			   ARG_BAR_STYLE);
  gtk_object_add_arg_type ("GtkSaneProgressBar::activity_step",
			   GTK_TYPE_UINT,
			   GTK_ARG_READWRITE,
			   ARG_ACTIVITY_STEP);
  gtk_object_add_arg_type ("GtkSaneProgressBar::activity_blocks",
			   GTK_TYPE_UINT,
			   GTK_ARG_READWRITE,
			   ARG_ACTIVITY_BLOCKS);
  gtk_object_add_arg_type ("GtkSaneProgressBar::discrete_blocks",
			   GTK_TYPE_UINT,
			   GTK_ARG_READWRITE,
			   ARG_DISCRETE_BLOCKS);
  
  widget_class->size_request = gtk_sane_progress_bar_size_request;

  object_class->set_arg = gtk_sane_progress_bar_set_arg;
  object_class->get_arg = gtk_sane_progress_bar_get_arg;
}

static void gtk_sane_progress_bar_init(GtkSaneProgressBar *bar)
{
  /* No local state; do nothing. */
}

static void
gtk_sane_progress_bar_set_arg (GtkObject           *object,
			       GtkArg              *arg,
			       guint                arg_id)
{
  GtkProgressBar *pbar;

  pbar = GTK_PROGRESS_BAR (object);

  switch (arg_id)
    {
    case ARG_ADJUSTMENT:
      gtk_progress_set_adjustment (GTK_PROGRESS (pbar), GTK_VALUE_POINTER (*arg));
      break;
    case ARG_ORIENTATION:
      gtk_progress_bar_set_orientation (pbar, GTK_VALUE_ENUM (*arg));
      break;
    case ARG_BAR_STYLE:
      gtk_progress_bar_set_bar_style (pbar, GTK_VALUE_ENUM (*arg));
      break;
    case ARG_ACTIVITY_STEP:
      gtk_progress_bar_set_activity_step (pbar, GTK_VALUE_UINT (*arg));
      break;
    case ARG_ACTIVITY_BLOCKS:
      gtk_progress_bar_set_activity_blocks (pbar, GTK_VALUE_UINT (*arg));
      break;
    case ARG_DISCRETE_BLOCKS:
      gtk_progress_bar_set_discrete_blocks (pbar, GTK_VALUE_UINT (*arg));
      break;
    default:
      break;
    }
}

static void
gtk_sane_progress_bar_get_arg (GtkObject           *object,
			       GtkArg              *arg,
			       guint                arg_id)
{
  GtkProgressBar *pbar;

  pbar = GTK_PROGRESS_BAR (object);

  switch (arg_id)
    {
    case ARG_ADJUSTMENT:
      GTK_VALUE_POINTER (*arg) = GTK_PROGRESS (pbar)->adjustment;
      break;
    case ARG_ORIENTATION:
      GTK_VALUE_ENUM (*arg) = pbar->orientation;
      break;
    case ARG_BAR_STYLE:
      GTK_VALUE_ENUM (*arg) = pbar->bar_style;
      break;
    case ARG_ACTIVITY_STEP:
      GTK_VALUE_UINT (*arg) = pbar->activity_step;
      break;
    case ARG_ACTIVITY_BLOCKS:
      GTK_VALUE_UINT (*arg) = pbar->activity_blocks;
      break;
    case ARG_DISCRETE_BLOCKS:
      GTK_VALUE_UINT (*arg) = pbar->blocks;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}

GtkType gtk_sane_progress_bar_get_type(void)
{
  static GtkType my_type = 0;
  
  if (!my_type)
  {
    static const GtkTypeInfo my_info =
    {
      "GtkSaneProgressBar",
      sizeof(GtkSaneProgressBar),
      sizeof(GtkSaneProgressBarClass),
      (GtkClassInitFunc) gtk_sane_progress_bar_class_init,
      (GtkObjectInitFunc) gtk_sane_progress_bar_init,
      /* reserved_1 */ NULL,
      /* reserved_2 */ NULL,
      (GtkClassInitFunc) NULL
    };

    my_type = gtk_type_unique(gtk_progress_bar_get_type(), &my_info);
  }

  return my_type;
}

GtkWidget *gtk_sane_progress_bar_new(void)
{
  GtkWidget *bar;
  bar = gtk_widget_new(gtk_sane_progress_bar_get_type(), NULL);
  return bar;
}

/* The remainder of this code is copied wholesale from
 * gtkprogressbar.c in the Gtk+-1.2.6 distribution.  Note that we have,
 * in fact, tweaked some of the key constants that make this work a little
 * better. */
static void
gtk_sane_progress_bar_size_request (GtkWidget      *widget,
				    GtkRequisition *requisition)
{
  GtkProgress *progress;
  GtkProgressBar *pbar;
  gchar *buf;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_PROGRESS_BAR (widget));
  g_return_if_fail (requisition != NULL);

  progress = GTK_PROGRESS (widget);
  pbar = GTK_PROGRESS_BAR (widget);

  if (pbar->orientation == GTK_PROGRESS_LEFT_TO_RIGHT ||
      pbar->orientation == GTK_PROGRESS_RIGHT_TO_LEFT)
    {
      if (progress->show_text && pbar->bar_style != GTK_PROGRESS_DISCRETE)
        {
          buf = gtk_progress_get_text_from_value (progress,
                                                  progress->adjustment->upper);

          requisition->width = MAX (MIN_HORIZONTAL_BAR_WIDTH,
                                    2 * widget->style->klass->xthickness + 3 +
                                    gdk_text_width (widget->style->font,
                                                    buf, strlen (buf)) +
                                    2 * TEXT_SPACING);

          requisition->height = MAX (MIN_HORIZONTAL_BAR_HEIGHT,
                                     2 * widget->style->klass->ythickness + 3 +
                                     gdk_text_height (widget->style->font,
                                                      buf, strlen (buf)) +
                                     2 * TEXT_SPACING);
          g_free (buf);
        }
      else
        {
          requisition->width = MIN_HORIZONTAL_BAR_WIDTH;
          requisition->height = MIN_HORIZONTAL_BAR_HEIGHT;
        }
    }
  else
    {
      if (progress->show_text && pbar->bar_style != GTK_PROGRESS_DISCRETE)
        {
          buf = gtk_progress_get_text_from_value (progress,
                                                  progress->adjustment->upper);

          requisition->width = MAX (MIN_VERTICAL_BAR_WIDTH,
                                    2 * widget->style->klass->xthickness + 3 +
                                    gdk_text_width (widget->style->font,
                                                    buf, strlen (buf)) +
                                    2 * TEXT_SPACING);

          requisition->height = MAX (MIN_VERTICAL_BAR_HEIGHT,
                                     2 * widget->style->klass->ythickness + 3 +
                                     gdk_text_height (widget->style->font,
                                                      buf, strlen (buf)) +
                                     2 * TEXT_SPACING);
          g_free (buf);
        }
      else
        {
          requisition->width = MIN_VERTICAL_BAR_WIDTH;
          requisition->height = MIN_VERTICAL_BAR_HEIGHT;
        }
    }
}
