/*
 * znola.c: A command-line heirarchical zephyr user listing
 * David Maze <dmaze@mit.edu>
 * $Id: znola.c,v 1.1 1999/04/11 19:14:12 dmaze Exp $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "anyone.h"
#include <stdio.h>

static void dump_group(zgroup *group);

int main(int argc, char **argv)
{
  GString *filename;
  zgroup *group;
  
  ZInitialize();

  filename = default_anyone();
  group = read_anyone(filename);
  g_string_free(filename, TRUE);

  dump_group(group);

  return 0;
}

static void dump_group(zgroup *group)
{
  GString *label, *name;
  GList *base, *list;
  zuser *user;
  int i;
  const ZLocations_t *loc;

  if (!zgroup_get_expanded(group))
    return;

  label = zgroup_label(group);
  printf("\n%s\n", label->str);
  
  base = zgroup_users(group);
  for (list = base; list; list = g_list_next(list))
  {
    user = list->data;
    
    /* There must be a better way to do this. */
    zuser_update(user);

    for (i = 0; i < zuser_count_locs(user); i++)
    {
      loc = zuser_get_loc(user, i);
      name = zuser_name(user);
      printf("%8s: %s %s\n", name->str, loc->time, loc->host);
      g_string_free(name, TRUE);
    }
  }
  g_list_free(base);

  base = zgroup_groups(group);
  for (list = base; list; list = g_list_next(list))
    dump_group(list->data);
}
