/*
 * gtkanyone.h: Show the user tree as a Gtk+ widget
 * David Maze <dmaze@mit.edu>
 * $Id: gtkanyone.h,v 1.15 2002/12/22 19:17:25 dmaze Exp $
 */

#ifndef __GTKANYONE_H__
#define __GTKANYONE_H__

#include <gtk/gtk.h>
#include "zgroup.h"

#define GTK_ANYONE(obj) GTK_CHECK_CAST((obj), gtk_anyone_get_type(), GtkAnyone)
#define GTK_ANYONE_CLASS(klass) GTK_CHECK_CLASS_CAST((klass), \
  gtk_anyone_get_type(), GtkAnyoneClass)
#define IS_GTK_ANYONE(obj) GTK_CHECK_TYPE((obj), gtk_anyone_get_type())

typedef struct _GtkAnyoneClass GtkAnyoneClass;
typedef struct _GtkAnyone GtkAnyone;

struct _GtkAnyoneClass
{
  GtkTreeClass parent_class;
};

struct _GtkAnyone
{
  GtkTree tree;
  
  zgroup *group;
  GString *filename;
  GtkTooltips *tips;
};

guint gtk_anyone_get_type(void);
GtkWidget *gtk_anyone_new(zgroup *group);
GtkWidget *gtk_anyone_open(GString *filename);
zgroup *gtk_anyone_group(const GtkAnyone *anyone);
GString *gtk_anyone_get_filename(const GtkAnyone *anyone);
void gtk_anyone_update(GtkAnyone *anyone, GtkProgress *progress);
void gtk_anyone_update_user(GtkAnyone *anyone, zuser *user);
void gtk_anyone_update_async(GtkAnyone *anyone);
void gtk_anyone_update_user_async(GtkAnyone *anyone, zuser *user);
void gtk_anyone_result_async(GtkAnyone *anyone, ZNotice_t *notice);
void gtk_anyone_construct(GtkAnyone *anyone, zgroup *group, GString *filename);

#endif /* __GTKANYONE_H__ */
