#include "string.h"
#include "cont.h"
#include "obj.h"
#include "wob.h"
#include "env.h"
#include "win_dep.h"
#include "widgetclass.h"
#include <X11/StringDefs.h>


#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>

#define define_widget_class(wobname, class_var) \
  (add_env(tlge, llcstring_to_sym(wobname), llmake_widgetclass_obj(class_var, 0,0,0)))

#define define_widget_class_with_constructor(wobname, class_var, constructor, show, hide) \
  (add_env(tlge, llcstring_to_sym(wobname), llmake_widgetclass_obj(class_var, constructor, show, hide)))


Xt_widget_set_init()
{
  xt_value_names_init();

  wob_pushbutton_init();
  wob_label_init();
  wob_box_init();
  wob_tackboard_init();
  wob_texteditor_init();
  wob_menubutton_init();
  wob_menupanel_init();
  wob_menuentry_init();
  wob_popup_init();
  wob_dialogbox_init();
  wob_scrollingwindow_init();
  wob_list_init();
}

#define define_name(llname, cname) add_env(tlge, llcstring_to_sym(llname), llcchars_to_string(cname))
#define define_num(llname, cname) add_env(tlge, llcstring_to_sym(llname), lldouble_to_num((double)cname))

xt_value_names_init()
{
  define_name("XtNaccelerators",XtNaccelerators);
  define_name("XtNallowHoriz",XtNallowHoriz);
  define_name("XtNallowVert",XtNallowVert);
  define_name("XtNancestorSensitive",XtNancestorSensitive);
  define_name("XtNbackground",XtNbackground);
  define_name("XtNbackgroundPixmap",XtNbackgroundPixmap);
  define_name("XtNbitmap",XtNbitmap);
  define_name("XtNborderColor",XtNborderColor);
  define_name("XtNborder",XtNborder);
  define_name("XtNborderPixmap",XtNborderPixmap);
  define_name("XtNborderWidth",XtNborderWidth);
  define_name("XtNcallback",XtNcallback);
  define_name("XtNchildren",XtNchildren);
  define_name("XtNcolormap",XtNcolormap);
  define_name("XtNdepth",XtNdepth);
  define_name("XtNdestroyCallback",XtNdestroyCallback);
  define_name("XtNeditType",XtNeditType);
  define_name("XtNfile",XtNfile);
  define_name("XtNfont",XtNfont);
  define_name("XtNforceBars",XtNforceBars);
  define_name("XtNforeground",XtNforeground);
  define_name("XtNfunction",XtNfunction);
  define_name("XtNheight",XtNheight);
  define_name("XtNhighlight",XtNhighlight);
  define_name("XtNhSpace",XtNhSpace);
  define_name("XtNindex",XtNindex);
  define_name("XtNinitialResourcesPersistent",XtNinitialResourcesPersistent);
  define_name("XtNinnerHeight",XtNinnerHeight);
  define_name("XtNinnerWidth",XtNinnerWidth);
  define_name("XtNinnerWindow",XtNinnerWindow);
  define_name("XtNinsertPosition",XtNinsertPosition);
  define_name("XtNinternalHeight",XtNinternalHeight);
  define_name("XtNinternalWidth",XtNinternalWidth);
  define_name("XtNjumpProc",XtNjumpProc);
  define_name("XtNjustify",XtNjustify);
  define_name("XtNknobHeight",XtNknobHeight);
  define_name("XtNknobIndent",XtNknobIndent);
  define_name("XtNknobPixel",XtNknobPixel);
  define_name("XtNknobWidth",XtNknobWidth);
  define_name("XtNlabel",XtNlabel);
  define_name("XtNlength",XtNlength);
  define_name("XtNlowerRight",XtNlowerRight);
  define_name("XtNmappedWhenManaged",XtNmappedWhenManaged);
  define_name("XtNmenuEntry",XtNmenuEntry);
  define_name("XtNname",XtNname);
  define_name("XtNnotify",XtNnotify);
  define_name("XtNnumChildren",XtNnumChildren);
  define_name("XtNorientation",XtNorientation);
  define_name("XtNparameter",XtNparameter);
  define_name("XtNpixmap",XtNpixmap);
  define_name("XtNpopupCallback",XtNpopupCallback);
  define_name("XtNpopdownCallback",XtNpopdownCallback);
  define_name("XtNresize",XtNresize);
  define_name("XtNreverseVideo",XtNreverseVideo);
  define_name("XtNscreen",XtNscreen);
  define_name("XtNscrollProc",XtNscrollProc);
  define_name("XtNscrollDCursor",XtNscrollDCursor);
  define_name("XtNscrollHCursor",XtNscrollHCursor);
  define_name("XtNscrollLCursor",XtNscrollLCursor);
  define_name("XtNscrollRCursor",XtNscrollRCursor);
  define_name("XtNscrollUCursor",XtNscrollUCursor);
  define_name("XtNscrollVCursor",XtNscrollVCursor);
  define_name("XtNselection",XtNselection);
  define_name("XtNselectionArray",XtNselectionArray);
  define_name("XtNsensitive",XtNsensitive);
  define_name("XtNshown",XtNshown);
  define_name("XtNspace",XtNspace);
  define_name("XtNstring",XtNstring);
  define_name("XtNtextOptions",XtNtextOptions);
  define_name("XtNtextSink",XtNtextSink);
  define_name("XtNtextSource",XtNtextSource);
  define_name("XtNthickness",XtNthickness);
  define_name("XtNthumb",XtNthumb);
  define_name("XtNthumbProc",XtNthumbProc);
  define_name("XtNtop",XtNtop);
  define_name("XtNtranslations",XtNtranslations);
  define_name("XtNunrealizeCallback",XtNunrealizeCallback);
  define_name("XtNupdate",XtNupdate);
  define_name("XtNuseBottom",XtNuseBottom);
  define_name("XtNuseRight",XtNuseRight);
  define_name("XtNvalue",XtNvalue);
  define_name("XtNvSpace",XtNvSpace);
  define_name("XtNwidth",XtNwidth);
  define_name("XtNwindow",XtNwindow);
  define_name("XtNx",XtNx);
  define_name("XtNy",XtNy);

}

/******************************* Pushbutton Wob ******************************/
wob_pushbutton_init()
{
  define_widget_class("WOB-PUSHBUTTON", commandWidgetClass);
}

/******************************* Label Wob ******************************/
wob_label_init()
{
  define_widget_class("WOB-LABEL", labelWidgetClass);
}

/******************************* Box Wob ******************************/
wob_box_init()
{
  define_widget_class("WOB-BOX", boxWidgetClass);
}

/******************************* Tackboard Wob ******************************/
void lltackboard_reconfigure()
{
  Wob* wob;
  wob = (Wob*)llnextcheckedarg(llwob_t);
  lllastarg();
  
  /*** FORM SPECIFIC ***/
  XawFormDoLayout(wob2widget(wob), True);
  llpusharg(T);
}

wob_tackboard_init()
{
  define_widget_class("WOB-TACKBOARD", formWidgetClass);

  /* from XawForm */
  define_name("XtNdefaultDistance",XtNdefaultDistance);
  define_name("XtNtop",XtNtop);
  define_name("XtNbottom",XtNbottom);
  define_name("XtNleft",XtNleft);
  define_name("XtNright",XtNright);
  define_name("XtNfromHoriz",XtNfromHoriz);
  define_name("XtNfromVert",XtNfromVert);
  define_name("XtNhorizDistance",XtNhorizDistance);
  define_name("XtNvertDistance",XtNvertDistance);
  define_name("XtNresizable",XtNresizable);

  define_num("XawChainTop",XawChainTop);
  define_num("XawChainBottom",XawChainBottom);
  define_num("XawChainLeft",XawChainLeft);
  define_num("XawChainRight",XawChainRight);
  define_num("XawRubber",XawRubber);			

  llregister_cfunc(lltackboard_reconfigure, "tackboard-reconfigure");
}


/******************************* Texteditor Wob ******************************/
wob_texteditor_init()
{
  define_widget_class("WOB-TEXTEDITOR", asciiTextWidgetClass);

  define_num("XawtextResizeNever", XawtextResizeNever);
  define_num("XawtextResizeWidth", XawtextResizeWidth);
  define_num("XawtextResizeHeight", XawtextResizeHeight);
  define_num("XawtextResizeBoth", XawtextResizeBoth);

  define_num("XawtextScrollNever", XawtextScrollNever);
  define_num("XawtextScrollWhenNeeded", XawtextScrollWhenNeeded);
  define_num("XawtextScrollAlways", XawtextScrollAlways);

  define_num("XawtextWrapNever", XawtextWrapNever);
  define_num("XawtextWrapLine", XawtextWrapLine);
  define_num("XawtextWrapWord", XawtextWrapWord);

  define_num("XawtextRead", XawtextRead);
  define_num("XawtextAppend", XawtextAppend);
  define_num("XawtextEdit", XawtextEdit);

  define_num("XawselectNull", XawselectNull);
  define_num("XawselectPosition", XawselectPosition);
  define_num("XawselectChar", XawselectChar);
  define_num("XawselectWord", XawselectWord);
  define_num("XawselectLine", XawselectLine);
  define_num("XawselectParagraph", XawselectParagraph);
  define_num("XawselectAll", XawselectAll);


}


/****************************** MenuButton Wob ******************************/

wob_menubutton_init()
{
  define_widget_class("WOB-MENUBUTTON", menuButtonWidgetClass);
  define_name("XtNmenuName",XtNmenuName);
}

/****************************** MenuPanel Wob ******************************/

wob_menupanel_init()
{
  define_widget_class_with_constructor("WOB-MENUPANEL", 
				       simpleMenuWidgetClass,
				       popup_widgetclass_constructor,
				       popup_widgetclass_show,
				       popup_widgetclass_hide
				       );
}


/****************************** MenuEntry Wob ******************************/

wob_menuentry_init()
{
  define_widget_class("WOB-MENUITEM", smeBSBObjectClass);
  define_widget_class("WOB-MENUITEM-LINE", smeLineObjectClass);
  define_widget_class("WOB-MENUITEM-BLANK", smeObjectClass);
}


/****************************** DialogBox Wob ******************************/
static void lldialog_get_text()
{
  LLString* str;
  Wob* wob; 
  wob = (Wob*) llnextcheckedarg(llwob_t);
  lllastarg();
  str = llcchars_to_string(XawDialogGetValueString(wob2widget(wob)));
  
  llpusharg(str);
}
wob_dialogbox_init()
{
  define_widget_class("WOB-DIALOGBOX", dialogWidgetClass);
  llregister_cfunc(lldialog_get_text, "dialog-get-text");
  
}


/****************************** Popup Wob ******************************/

wob_popup_init()
{
  define_widget_class_with_constructor("WOB-POPUP", 
				       transientShellWidgetClass,
				       popup_widgetclass_constructor,
				       popup_widgetclass_show,
				       popup_widgetclass_hide
				       );
				       
}

/******************************* ScrollingWindow Wob ******************************/

wob_scrollingwindow_init()
{
  define_widget_class("WOB-SCROLLINGWINDOW", viewportWidgetClass);

  define_name("XtNforceBars",XtNforceBars);
  define_name("XtNallowHoriz",XtNallowHoriz);
  define_name("XtNallowVert",XtNallowVert);
  define_name("XtNuseBottom",XtNuseBottom);
  define_name("XtNuseRight",XtNuseRight);
}

/****************************** List Wob ******************************/
static void llload_list_wob()
{
  Wob* wob;
  LLCons* cons;
  int i = 0, listlength;
  char** ptr;

  wob = (Wob*)llnextcheckedarg(llwob_t);
  cons = (LLCons*)llnextcheckedarg(llcons_t);
  listlength = llclength(cons);
  lllastarg();

  if(wob->extra) free(wob->extra);
  wob->extra = (void*)malloc(sizeof(char*) * listlength);
  ptr = (char**) wob->extra;
  while(cons != (LLCons*)NIL) {
    lltypecheck(llccar(cons), llstring_t);
    ptr[i] = llcstring_to_chars((LLString*)llccar(cons));
    i++;
    cons = (LLCons*)llccdr(cons);
  }
  XawListChange(wob2widget(wob), wob->extra, listlength, -1, True);
  llpusharg(T);
}
/*ARGSUSED*/
static void list_callback(w, proc, cbstruct)
     Widget w;
     LLObj* proc;
     XawListReturnStruct* cbstruct;
{
  lltop_level_form( llcmake_cons( proc, 
				 llcmake_cons( lldouble_to_num((double)cbstruct->list_index), 
					      NIL )));
}

static void set_list_callback()
{
  Wob* wob;
  LLObj* val;
  wob = (Wob*)llnextcheckedarg(llwob_t);
  val = (LLObj*)llnextarg();
  lllastarg();
  XtAddCallback(wob2widget(wob), XtNcallback, list_callback, val);
  llpusharg(T);
}

wob_list_init()
{
  define_widget_class("WOB-LIST", listWidgetClass);

  define_name("XtNcursor",XtNcursor);
  define_name("XtNcolumnSpacing",XtNcolumnSpacing);
  define_name("XtNdefaultColumns",XtNdefaultColumns);
  define_name("XtNforceColumns",XtNforceColumns);
  define_name("XtNlist",XtNlist);
  define_name("XtNlongest",XtNlongest);
  define_name("XtNnumberStrings",XtNnumberStrings);
  define_name("XtNpasteBuffer",XtNpasteBuffer);
  define_name("XtNrowSpacing",XtNrowSpacing);
  define_name("XtNverticalList",XtNverticalList);
  llregister_cfunc(llload_list_wob, "load-list-wob");
  llregister_cfunc(set_list_callback, "set-list-callback");
}
