/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include "obj.h"
#include "delay.h"
#include "cont.h"
#include "stream.h"

LLTag lldelay_t;

LLDelay *llmake_delay(bytecode, objects, env)
     LLString *bytecode; 
     LLVector *objects;
     LLEnv *env; 
{
  LLDelay *d; 
  d = (LLDelay *) llmake_obj(lldelay_t);
  d->value.delay = llmake_closure(bytecode, objects, (LLCons *) NIL, env);
  d->state = LLDELAYED; 
  return d;
}

static void llforce() 
{
  LLDelay *d; 

  d = (LLDelay *) llnextarg();
  lllastarg();
  if (!llis_delay(d))
    llpusharg(d);
  else
    if(d->state != LLFORCED) {
      d->state = LLFORCED;
      llpusharg(d->value.delay);
      llargc = 0; 
      llapply();
      d->value.forced_value = llpeekarg(); 
    } else {
      llpusharg(d->value.forced_value);
    }
}

static void touch_delay(d)
     LLDelay *d;
{
  if(d->state == LLDELAYED) {
    lltouch_obj((LLObj *) d->value.delay);
  } else {
    lltouch_obj((LLObj *) d->value.forced_value);
  }
}

static void print_delay(d, stream)
     LLDelay *d; 
     LLStream *stream; 
{
  llstrprintf(stream, "<%sromise %08X>",((d->state == LLDELAYED) ? "P" : "Forced p"), d);
}

void lltail() 
{
  void *temp1;
  temp1 = llnextcheckedarg(llcons_t);
  llpusharg(llccdr(temp1));
  llargc++;
  llforce();
}

void llinit_delay() 
{
  llregister_cfunc(llforce, "force"); 
  llregister_cfunc(llcar, "head"); 
  llregister_cfunc(lltail, "tail");
  lldelay_t = lladd_obj_td(sizeof(LLDelay), "Delay", 
			   0, touch_delay, print_delay, 0);
}
