/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _ERROR_INC 
#define _ERROR_INC 
#include <setjmp.h>

#include <signal.h>

extern jmp_buf llerror_toplevel; 
extern void llinterrupt();

#define llinit_error()  signal(SIGINT, llinterrupt),llerror_recover(setjmp(llerror_toplevel))

#define llerror(msg) longjmp(llerror_toplevel, msg)
#define llperror(msg, extra) llerror_set_extra(extra),llerror(msg)

typedef enum llerror_e {
  LLNO_ERROR = 0,
  LLNO_MESSAGE,
  LLNO_MEMORY,
  LLINVALID_OBJECT,
  LLEMPTY_STACK, 
  LLREAD_ONLY_STREAM, 
  LLNOT_A_FILE,
  LLTOO_FEW_ARGS,
  LLARGS_OUT_OF_RANGE,
  LLTOO_MANY_ARGS,
  LLEND_OF_STREAM, 
  LLBAD_LIST,
  LLSYNTAX_ERROR, 
  LLTYPE_ERROR,
  LLBAD_BYTE_CODE,
  LLBAD_FUNCTION,
  LLWRONG_NARGS,
  LLUNBOUND_SYMBOL, 
  LLBAD_LAMBDA,
  LLCOMP_OUT_OF_SPACE,
  LLBAD_FORM,
  LLTOO_MANY_TDS,
  LLREAD_ERROR,
  LLMISMATCHED_PAREN,
  LLCANT_OPEN,
  LLINTERNAL_ERROR,
} LLError;


#endif 
