
# line 2 "dgn_comp.y"
/*	SCCS Id: @(#)dgn_comp.c	3.1	93/05/15	*/
/*	Copyright (c) 1989 by Jean-Christophe Collet */
/*	Copyright (c) 1990 by M. Stephenson				  */
/* NetHack may be freely redistributed.  See license for details. */

/*
 * This file contains the Dungeon Compiler code
 */

/* In case we're using bison in AIX.  This definition must be
 * placed before any other C-language construct in the file
 * excluding comments and preprocessor directives (thanks IBM
 * for this wonderful feature...).
 *
 * Note: some cpps barf on this 'undefined control' (#pragma).
 * Addition of the leading space seems to prevent barfage for now,
 * and AIX will still see the directive in its non-standard locale.
 */

#ifdef _AIX
 #pragma alloca		/* keep leading space! */
#endif

#include "config.h"
#include "dgn_file.h"

void FDECL(yyerror, (const char *));
void FDECL(yywarning, (const char *));
int NDECL(yylex);
int NDECL(yyparse);
int FDECL(getchain, (char *));
int NDECL(check_dungeon);
int NDECL(check_branch);
int NDECL(check_level);
void NDECL(init_dungeon);
void NDECL(init_branch);
void NDECL(init_level);
void NDECL(output_dgn);

#ifdef AMIGA
# undef	printf
#ifndef	LATTICE
# define    memset(addr,val,len)    setmem(addr,len,val)
#endif
#endif

#ifdef MICRO
# undef exit
extern void FDECL(exit, (int));
#endif

#undef NULL

#define ERR		(-1)

static struct couple couple;
static struct tmpdungeon tmpdungeon[MAXDUNGEON];
static struct tmplevel tmplevel[LEV_LIMIT];
static struct tmpbranch tmpbranch[BRANCH_LIMIT];

static int in_dungeon = 0, n_dgns = -1, n_levs = -1, n_brs = -1;

extern int fatal_error;
extern const char *fname;


# line 69 "dgn_comp.y"
typedef union 
{
	int	i;
	char*	str;
} YYSTYPE;
# define INTEGER 257
# define A_DUNGEON 258
# define BRANCH 259
# define CHBRANCH 260
# define LEVEL 261
# define RNDLEVEL 262
# define CHLEVEL 263
# define RNDCHLEVEL 264
# define UP_OR_DOWN 265
# define PROTOFILE 266
# define DESCRIPTION 267
# define DESCRIPTOR 268
# define LEVELDESC 269
# define ALIGNMENT 270
# define LEVALIGN 271
# define ENTRY 272
# define STAIR 273
# define NO_UP 274
# define NO_DOWN 275
# define PORTAL 276
# define STRING 277
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 450 "dgn_comp.y"


void
init_dungeon()
{
	if(++n_dgns > MAXDUNGEON) {
	    fprintf(stderr, "FATAL - Too many dungeons (limit: %d).\n",
		    MAXDUNGEON);
	    fprintf(stderr, "To increase the limit edit MAXDUNGEON in global.h\n");
	    exit(1);
	}

	in_dungeon = 1;
	tmpdungeon[n_dgns].lev.base = 0;
	tmpdungeon[n_dgns].lev.rand = 0;
	tmpdungeon[n_dgns].chance = 100;
	strcpy(tmpdungeon[n_dgns].name, "");
	strcpy(tmpdungeon[n_dgns].protoname, "");
	tmpdungeon[n_dgns].flags = 0;
	tmpdungeon[n_dgns].levels = 0;
	tmpdungeon[n_dgns].branches = 0;
	tmpdungeon[n_dgns].entry_lev = 0;
}

void
init_level()
{
	if(++n_levs > LEV_LIMIT) {

		yyerror("FATAL - Too many special levels defined.");
		exit(1);
	}
	tmplevel[n_levs].lev.base = 0;
	tmplevel[n_levs].lev.rand = 0;
	tmplevel[n_levs].chance = 100;
	tmplevel[n_levs].rndlevs = 0;
	tmplevel[n_levs].flags = 0;
	strcpy(tmplevel[n_levs].name, "");
	tmplevel[n_levs].chain = -1;
}

void
init_branch()
{
	if(++n_brs > BRANCH_LIMIT) {

		yyerror("FATAL - Too many special levels defined.");
		exit(1);
	}
	tmpbranch[n_brs].lev.base = 0;
	tmpbranch[n_brs].lev.rand = 0;
	strcpy(tmpbranch[n_brs].name, "");
	tmpbranch[n_brs].chain = -1;
}

int
getchain(s)
	char	*s;
{
	int i;

	if(strlen(s)) {

	    for(i = n_levs - tmpdungeon[n_dgns].levels + 1; i <= n_levs; i++)
		if(!strcmp(tmplevel[i].name, s)) return i;

	    yyerror("Can't locate the specified chain level.");
	    return(-2);
	}
	return(-1);
}

/*
 *	Consistancy checking routines:
 *
 *	- A dungeon must have a unique name.
 *	- A dungeon must have a originating "branch" command
 *	  (except, of course, for the first dungeon).
 *	- A dungeon must have a proper depth (at least (1, 0)).
 */

int
check_dungeon()
{
	int i;

	for(i = 0; i < n_dgns; i++)
	    if(!strcmp(tmpdungeon[i].name, tmpdungeon[n_dgns].name)) {
		yyerror("Duplicate dungeon name.");
		return(0);
	    }

	if(n_dgns)
	  for(i = 0; i < n_brs - tmpdungeon[n_dgns].branches; i++) {
	    if(!strcmp(tmpbranch[i].name, tmpdungeon[n_dgns].name)) break;

	    if(i >= n_brs - tmpdungeon[n_dgns].branches) {
		yyerror("Dungeon cannot be reached.");
		return(0);
	    }
	  }

	if(tmpdungeon[n_dgns].lev.base <= 0 ||
	   tmpdungeon[n_dgns].lev.rand < 0) {
		yyerror("Invalid dungeon depth specified.");
		return(0);
	}
	return(1);	/* OK */
}

/*
 *	- A level must have a unique level name.
 *	- If chained, the level used as reference for the chain
 *	  must be in this dungeon, must be previously defined, and
 *	  the level chained from must be "non-probabalistic" (ie.
 *	  have a 100% chance of existing).
 */

int
check_level()
{
	int i;

	if(!in_dungeon) {
		yyerror("Level defined outside of dungeon.");
		return(0);
	}

	for(i = 0; i < n_levs; i++)
	    if(!strcmp(tmplevel[i].name, tmplevel[n_levs].name)) {
		yyerror("Duplicate level name.");
		return(0);
	    }

	if(tmplevel[i].chain == -2) {
		yyerror("Invaild level chain reference.");
		return(0);
	} else if(tmplevel[i].chain != -1) {	/* there is a chain */
	    if(tmplevel[tmpbranch[i].chain].chance != 100) {
		yyerror("Level cannot chain from a probabalistic level.");
		return(0);
	    } else if(tmplevel[i].chain == n_levs) {
		yyerror("A level cannot chain to itself!");
		return(0);
	    }
	}
	return(1);	/* OK */
}

/*
 *	- A branch may not branch backwards - to avoid branch loops.
 *	- A branch name must be unique.
 *	  (ie. You can only have one entry point to each dungeon).
 *	- If chained, the level used as reference for the chain
 *	  must be in this dungeon, must be previously defined, and
 *	  the level chained from must be "non-probabalistic" (ie.
 *	  have a 100% chance of existing).
 */

int
check_branch()
{
	int i;

	if(!in_dungeon) {
		yyerror("Branch defined outside of dungeon.");
		return(0);
	}

	for(i = 0; i < n_dgns; i++)
	    if(!strcmp(tmpdungeon[i].name, tmpbranch[n_brs].name)) {

		yyerror("Reverse branching not allowed.");
		return(0);
	    }

	if(tmpbranch[i].chain == -2) {

		yyerror("Invaild branch chain reference.");
		return(0);
	} else if(tmpbranch[i].chain != -1) {	/* it is chained */

	    if(tmplevel[tmpbranch[i].chain].chance != 100) {
		yyerror("Branch cannot chain from a probabalistic level.");
		return(0);
	    }
	}
	return(1);	/* OK */
}

/*
 *	Output the dungon definition into a file.
 *
 *	The file will have the following format:
 *
 *	[ number of dungeons ]
 *	[ first dungeon struct ]
 *	[ levels for the first dungeon ]
 *	  ...
 *	[ branches for the first dungeon ]
 *	  ...
 *	[ second dungeon struct ]
 *	  ...
 */

void
output_dgn()
{
	int	nd, cl = 0, nl = 0,
		    cb = 0, nb = 0;

	if(++n_dgns <= 0) {

	    yyerror("FATAL - no dungeons were defined.");
	    exit(1);
	}

	fwrite((char *)(&n_dgns), sizeof(int), 1, stdout);
	for(nd = 0; nd < n_dgns; nd++) {

	    fwrite((char *)&tmpdungeon[nd], sizeof(struct tmpdungeon), 1,
								stdout);

	    nl += tmpdungeon[nd].levels;
	    for(; cl < nl; cl++)
		fwrite((char *)&tmplevel[cl], sizeof(struct tmplevel), 1,
								stdout);

	    nb += tmpdungeon[nd].branches;
	    for(; cb < nb; cb++)
		fwrite((char *)&tmpbranch[cb], sizeof(struct tmpbranch), 1,
								stdout);
	}
}
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 48
# define YYLAST 145
short yyact[]={

   8,  22,  23,  24,  25,  28,  29,  74,  21,  30,
  73,  26,  31,  27,  19,  65,  79,  80,  81,  82,
 106,  64,  63,  62,  61,  59,  56,  55,  52,  51,
  50,  49,  48,  46,  58,  57,  54,  53,  91, 103,
 102, 101,  99,  98,  95,  94,  83,  77,  76,  47,
  90,  66,  78,  68,  72,  71,  60,  45,  44,  43,
  42,  41,  40,  39,  38,  37,  36,  35,  34,  33,
  92,  89,  88,  87,  70, 105, 104,  67,  69,   3,
  13,  12,  32,  18,  17,  16,  15,  14,  20,  11,
  10,   9,   7,   6,   5,   4,   2,   1,  75,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,  84,   0,   0,  85,  86,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  93,   0,  96,
  97,   0,   0,   0, 100 };
short yypact[]={

-258,-1000,-258,-1000,-1000,-1000,-1000,-1000,  11,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  10,
-1000,   9,   8,   7,   6,   5,   4,   3,   2,   1,
   0,  -1,-1000,-244,-208,-245,-246,-247,-248,-249,
-231,-232,-250,-251,-233,-234,-252,-1000,-1000,  -8,
-253,-254,-255,-1000,-1000,-256,-262,-1000,-1000,  37,
  38,  31,  -9, -10,-267,-270,-209,-210,-257,-211,
  37,  38,  38,  30,  29,-1000,-1000,  27,-227,-1000,
-1000,-1000,-1000,  26,-257,-212,-213,  37,  37,-214,
-1000,-1000,-215,-227,-1000,-216,-217,-218,  35,  34,
-1000,-1000,-1000,-237,-1000,-1000,-1000 };
short yypgo[]={

   0,  98,  50,  52,  97,  96,  79,  95,  94,  93,
  92,  51,  91,  90,  89,  88,  87,  86,  85,  84,
  83,  53,  81,  80 };
short yyr1[]={

   0,   4,   4,   5,   5,   6,   6,   6,   6,   7,
   1,   1,   8,   8,   8,  12,  13,  15,  15,  14,
  10,  10,  10,  10,  10,  16,  16,  17,  17,  18,
  18,  19,  19,  20,  20,   9,   9,  22,  23,   3,
   3,   3,   3,   3,   2,   2,  21,  11 };
short yyr2[]={

   0,   0,   1,   1,   2,   1,   1,   1,   1,   6,
   0,   1,   1,   1,   1,   3,   1,   3,   3,   3,
   1,   1,   1,   1,   1,   6,   7,   7,   8,   3,
   3,   7,   8,   8,   9,   1,   1,   7,   8,   0,
   1,   1,   1,   1,   0,   1,   5,   5 };
short yychk[]={

-1000,  -4,  -5,  -6,  -7,  -8,  -9, -10, 258, -12,
 -13, -14, -22, -23, -16, -17, -18, -19, -20, 272,
 -15, 266, 259, 260, 261, 262, 269, 271, 263, 264,
 267, 270,  -6,  58,  58,  58,  58,  58,  58,  58,
  58,  58,  58,  58,  58,  58, 277, 257, 277, 277,
 277, 277, 277, 268, 268, 277, 277, 268, 268, 277,
  64, 277, 277, 277, 277, 277, -11,  40, -21,  40,
  43,  64,  64, 277, 277,  -1, 257, 257,  -3, 273,
 274, 275, 276, 257, -11, -21, -21,  43,  43,  44,
  -2, 265,  44,  -3, 257, 257, -11, -11, 257, 257,
  -2, 257, 257, 257,  41,  41, 257 };
short yydef[]={

   1,  -2,   2,   3,   5,   6,   7,   8,   0,  12,
  13,  14,  35,  36,  20,  21,  22,  23,  24,   0,
  16,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  15,  19,   0,
   0,   0,   0,  29,  30,   0,   0,  17,  18,   0,
   0,   0,   0,   0,   0,   0,  10,   0,  39,   0,
   0,   0,   0,   0,   0,   9,  11,   0,  44,  40,
  41,  42,  43,   0,  39,  25,   0,   0,   0,   0,
  37,  45,   0,  44,  27,  26,  31,   0,   0,   0,
  38,  28,  33,  32,  47,  46,  34 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 2:
# line 86 "dgn_comp.y"
{
			output_dgn();
		  } break;
case 9:
# line 102 "dgn_comp.y"
{
			init_dungeon();
			strcpy(tmpdungeon[n_dgns].name, yypvt[-3].str);
			if (!strcmp(yypvt[-2].str, "none"))
				tmpdungeon[n_levs].boneschar = '\0';
			else if (yypvt[-2].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmpdungeon[n_dgns].boneschar = yypvt[-2].str[0];
			tmpdungeon[n_dgns].lev.base = couple.base;
			tmpdungeon[n_dgns].lev.rand = couple.rand;
			tmpdungeon[n_dgns].chance = yypvt[-0].i;
		  } break;
case 10:
# line 118 "dgn_comp.y"
{
			yyval.i = 0;
		  } break;
case 11:
# line 122 "dgn_comp.y"
{
			yyval.i = yypvt[-0].i;
		  } break;
case 15:
# line 133 "dgn_comp.y"
{
			tmpdungeon[n_dgns].entry_lev = yypvt[-0].i;
		  } break;
case 17:
# line 142 "dgn_comp.y"
{
			if(yypvt[-0].i <= TOWN || yypvt[-0].i >= D_ALIGN_CHAOTIC)
			    yyerror("Illegal description - ignoring!");
			else
			    tmpdungeon[n_dgns].flags |= yypvt[-0].i ;
		  } break;
case 18:
# line 149 "dgn_comp.y"
{
			if(yypvt[-0].i && yypvt[-0].i < D_ALIGN_CHAOTIC)
			    yyerror("Illegal alignment - ignoring!");
			else
			    tmpdungeon[n_dgns].flags |= yypvt[-0].i ;
		  } break;
case 19:
# line 158 "dgn_comp.y"
{
			strcpy(tmpdungeon[n_dgns].protoname, yypvt[-0].str);
		  } break;
case 25:
# line 171 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-3].str);
			if (!strcmp(yypvt[-2].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-2].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-2].str[0];
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmpdungeon[n_dgns].levels++;
		  } break;
case 26:
# line 185 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-4].str);
			if (!strcmp(yypvt[-3].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-3].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-3].str[0];
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmplevel[n_levs].rndlevs = yypvt[-0].i;
			tmpdungeon[n_dgns].levels++;
		  } break;
case 27:
# line 202 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-4].str);
			if (!strcmp(yypvt[-3].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-3].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-3].str[0];
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmplevel[n_levs].chance = yypvt[-0].i;
			tmpdungeon[n_dgns].levels++;
		  } break;
case 28:
# line 217 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-5].str);
			if (!strcmp(yypvt[-4].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-4].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-4].str[0];
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmplevel[n_levs].chance = yypvt[-1].i;
			tmplevel[n_levs].rndlevs = yypvt[-0].i;
			tmpdungeon[n_dgns].levels++;
		  } break;
case 29:
# line 235 "dgn_comp.y"
{
			if(yypvt[-0].i >= D_ALIGN_CHAOTIC)
			    yyerror("Illegal description - ignoring!");
			else
			    tmplevel[n_levs].flags |= yypvt[-0].i ;
		  } break;
case 30:
# line 242 "dgn_comp.y"
{
			if(yypvt[-0].i && yypvt[-0].i < D_ALIGN_CHAOTIC)
			    yyerror("Illegal alignment - ignoring!");
			else
			    tmplevel[n_levs].flags |= yypvt[-0].i ;
		  } break;
case 31:
# line 251 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-4].str);
			if (!strcmp(yypvt[-3].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-3].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-3].str[0];
			tmplevel[n_levs].chain = getchain(yypvt[-2].str);
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			if(!check_level()) n_levs--;
			else tmpdungeon[n_dgns].levels++;
		  } break;
case 32:
# line 267 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-5].str);
			if (!strcmp(yypvt[-4].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-4].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-4].str[0];
			tmplevel[n_levs].chain = getchain(yypvt[-3].str);
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmplevel[n_levs].rndlevs = yypvt[-0].i;
			if(!check_level()) n_levs--;
			else tmpdungeon[n_dgns].levels++;
		  } break;
case 33:
# line 286 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-5].str);
			if (!strcmp(yypvt[-4].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-4].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-4].str[0];
			tmplevel[n_levs].chain = getchain(yypvt[-3].str);
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmplevel[n_levs].chance = yypvt[-0].i;
			if(!check_level()) n_levs--;
			else tmpdungeon[n_dgns].levels++;
		  } break;
case 34:
# line 303 "dgn_comp.y"
{
			init_level();
			strcpy(tmplevel[n_levs].name, yypvt[-6].str);
			if (!strcmp(yypvt[-5].str, "none"))
				tmplevel[n_levs].boneschar = '\0';
			else if (yypvt[-5].str[1])
				yyerror("Bones marker must be a single char, or \"none\"!");
			else
				tmplevel[n_levs].boneschar = yypvt[-5].str[0];
			tmplevel[n_levs].chain = getchain(yypvt[-4].str);
			tmplevel[n_levs].lev.base = couple.base;
			tmplevel[n_levs].lev.rand = couple.rand;
			tmplevel[n_levs].chance = yypvt[-1].i;
			tmplevel[n_levs].rndlevs = yypvt[-0].i;
			if(!check_level()) n_levs--;
			else tmpdungeon[n_dgns].levels++;
		  } break;
case 37:
# line 327 "dgn_comp.y"
{
			init_branch();
			strcpy(tmpbranch[n_brs].name, yypvt[-4].str);
			tmpbranch[n_brs].lev.base = couple.base;
			tmpbranch[n_brs].lev.rand = couple.rand;
			tmpbranch[n_brs].type = yypvt[-1].i;
			tmpbranch[n_brs].up = yypvt[-0].i;
			if(!check_branch()) n_brs--;
			else tmpdungeon[n_dgns].branches++;
		  } break;
case 38:
# line 340 "dgn_comp.y"
{
			init_branch();
			strcpy(tmpbranch[n_brs].name, yypvt[-5].str);
			tmpbranch[n_brs].chain = getchain(yypvt[-4].str);
			tmpbranch[n_brs].lev.base = couple.base;
			tmpbranch[n_brs].lev.rand = couple.rand;
			tmpbranch[n_brs].type = yypvt[-1].i;
			tmpbranch[n_brs].up = yypvt[-0].i;
			if(!check_branch()) n_brs--;
			else tmpdungeon[n_dgns].branches++;
		  } break;
case 39:
# line 354 "dgn_comp.y"
{
			yyval.i = TBR_STAIR;	/* two way stair */
		  } break;
case 40:
# line 358 "dgn_comp.y"
{
			yyval.i = TBR_STAIR;	/* two way stair */
		  } break;
case 41:
# line 362 "dgn_comp.y"
{
			yyval.i = TBR_NO_UP;	/* no up staircase */
		  } break;
case 42:
# line 366 "dgn_comp.y"
{
			yyval.i = TBR_NO_DOWN;	/* no down staircase */
		  } break;
case 43:
# line 370 "dgn_comp.y"
{
			yyval.i = TBR_PORTAL;	/* portal connection */
		  } break;
case 44:
# line 376 "dgn_comp.y"
{
			yyval.i = 0;	/* defaults to down */
		  } break;
case 45:
# line 380 "dgn_comp.y"
{
			yyval.i = yypvt[-0].i;
		  } break;
case 46:
# line 403 "dgn_comp.y"
{
			if (yypvt[-3].i < -MAXLEVEL || yypvt[-3].i > MAXLEVEL) {
			    yyerror("Abs base out of dlevel range - zeroing!");
			    couple.base = couple.rand = 0;
			} else if (yypvt[-1].i < -1 ||
				((yypvt[-3].i < 0) ? (MAXLEVEL + yypvt[-3].i + yypvt[-1].i + 1) > MAXLEVEL :
					(yypvt[-3].i + yypvt[-1].i) > MAXLEVEL)) {
			    yyerror("Abs range out of dlevel range - zeroing!");
			    couple.base = couple.rand = 0;
			} else {
			    couple.base = yypvt[-3].i;
			    couple.rand = yypvt[-1].i;
			}
		  } break;
case 47:
# line 440 "dgn_comp.y"
{
			if (yypvt[-3].i < -MAXLEVEL || yypvt[-3].i > MAXLEVEL) {
			    yyerror("Rel base out of dlevel range - zeroing!");
			    couple.base = couple.rand = 0;
			} else {
			    couple.base = yypvt[-3].i;
			    couple.rand = yypvt[-1].i;
			}
		  } break; 
		}
		goto yystack;  /* stack new state and value */

	}
