/*
  tools.h

  For Tux Paint
  List of available tools.

  Copyright (c) 2002 by Bill Kendrick
  bill@newbreedsoftware.com
  http://www.newbreedsoftware.com/tuxpaint/

  June 29, 2002 - August 4, 2002
*/


#include "tip_tux.h"


/* What tools are available: */

enum {
  MAGIC_RAINBOW,
  MAGIC_SPARKLES,

  MAGIC_MIRROR,
  MAGIC_FLIP,
  
  MAGIC_BLUR,
  MAGIC_BLOCKS,
  
  MAGIC_NEGATIVE,
  MAGIC_FADE,
  
  MAGIC_CHALK,
  MAGIC_DRIP,
  
  MAGIC_THICK,
  MAGIC_THIN,

  MAGIC_FILL,
  
  NUM_MAGICS
};


/* Magic tool names: */

char * magic_names[NUM_MAGICS] = {
  gettext_noop("Rainbow"),
  gettext_noop("Sparkles"),

  gettext_noop("Mirror"),
  gettext_noop("Flip"),

  gettext_noop("Blur"),
  gettext_noop("Blocks"),

  gettext_noop("Negative"),
  gettext_noop("Fade"),

  gettext_noop("Chalk"),
  gettext_noop("Drip"),

  gettext_noop("Thick"),
  gettext_noop("Thin"),

  gettext_noop("Fill")
};


/* Some text to write when each tool is selected: */

char * magic_tips[NUM_MAGICS] = {
  gettext_noop("You can draw in rainbow colors!"),
  gettext_noop("Click and move to draw sparkles"),
  
  gettext_noop("Click to make a mirror image!"),
  gettext_noop("Click to flip the picture upside-down!"),
  
  gettext_noop("Click and move the mouse around to blur the picture"),
  gettext_noop("Click and move the mouse around to make the picture blocky"),
  
  gettext_noop("Click and move the mouse around to draw a negative"),
  gettext_noop("Click and move to fade the colors."),
  
  gettext_noop("Click and move the mouse around to turn the picture into a chalk drawing."),
  gettext_noop("Click and move the mouse around to make the picture drip!"),
  
  gettext_noop("Click and move the mouse to thicken the picture"),
  gettext_noop("Click and move the mouse to thin the picture"),

  gettext_noop("Click in the picture to fill that area with color")
};


/* Tool icon filenames: */

char * magic_img_fnames[NUM_TOOLS] = {
  DATA_PREFIX "images/magic/rainbow.png",
  DATA_PREFIX "images/magic/sparkles.png",
  
  DATA_PREFIX "images/magic/mirror.png",
  DATA_PREFIX "images/magic/flip.png",
  
  DATA_PREFIX "images/magic/blur.png",
  DATA_PREFIX "images/magic/blocks.png",
  
  DATA_PREFIX "images/magic/negative.png",
  DATA_PREFIX "images/magic/fade.png",
  
  DATA_PREFIX "images/magic/chalk.png",
  DATA_PREFIX "images/magic/drip.png",
  
  DATA_PREFIX "images/magic/thick.png",
  DATA_PREFIX "images/magic/thin.png",

  DATA_PREFIX "images/magic/fill.png"
};


/* FIXME: Should we should different Tux icons depending on magic,
   like tools? */


/* Rainbow color values: */

#define NUM_RAINBOW_COLORS 23

int rainbow_hexes[NUM_RAINBOW_COLORS][3] = {
  {255, 0, 0},
  {255, 64, 0},
  {255, 128, 0},
  {255, 192, 0},
  {255, 255, 0},
  {192, 255, 0},
  {128, 255, 0},
  {64, 255, 0},
  {0, 255, 0},
  {0, 255, 64},
  {0, 255, 128},
  {0, 255, 192},
  {0, 255, 255},
  {0, 192, 255},
  {0, 128, 255},
  {0, 64, 255},
  {64, 0, 255},
  {128, 0, 255},
  {192, 0, 255},
  {255, 0, 255},
  {255, 0, 192},
  {255, 0, 128},
  {255, 0, 64}
};

