dnl ---------------------------------------------------------------------------
dnl Check for data that is usually declared in <stdio.h> or <errno.h>
dnl $1 = the name to check
AC_DEFUN([CF_CHECK_ERRNO],
[
AC_MSG_CHECKING([declaration of $1])
AC_CACHE_VAL(cf_cv_dcl_$1,[
    AC_TRY_COMPILE([
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <stdio.h>
#include <sys/types.h>
#include <errno.h> ],
    [long x = (long) $1],
    [eval 'cf_cv_dcl_'$1'=yes'],
    [eval 'cf_cv_dcl_'$1'=no]')])
eval 'cf_result=$cf_cv_dcl_'$1
AC_MSG_RESULT($cf_result)

# It's possible (for near-UNIX clones) that the data doesn't exist
AC_CACHE_VAL(cf_cv_have_$1,[
if test $cf_result = no ; then
    eval 'cf_result=DECL_'$1
    CF_UPPER(cf_result,$cf_result)
    AC_DEFINE_UNQUOTED($cf_result)
    AC_MSG_CHECKING([existence of $1])
        AC_TRY_LINK([
#undef $1
extern long $1;
],
            [$1 = 2],
            [eval 'cf_cv_have_'$1'=yes'],
            [eval 'cf_cv_have_'$1'=no'])
        eval 'cf_result=$cf_cv_have_'$1
        AC_MSG_RESULT($cf_result)
else
    eval 'cf_cv_have_'$1'=yes'
fi
])
eval 'cf_result=HAVE_'$1
CF_UPPER(cf_result,$cf_result)
eval 'test $cf_cv_have_'$1' = yes && AC_DEFINE_UNQUOTED($cf_result)'
])dnl
dnl ---------------------------------------------------------------------------
dnl Check if 'errno' is declared in <errno.h>
AC_DEFUN([CF_ERRNO],
[
CF_CHECK_ERRNO(errno)
])dnl
dnl ---------------------------------------------------------------------------
dnl Make an uppercase version of a variable
dnl $1=uppercase($2)
AC_DEFUN([CF_UPPER],
[
changequote(,)dnl
$1=`echo $2 | tr '[a-z]' '[A-Z]'`
changequote([,])dnl
])dnl
