/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __ANI_PIXMAP_H__
#define __ANI_PIXMAP_H__


#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ANI_PIXMAP(obj)          GTK_CHECK_CAST (obj, ani_pixmap_get_type (), AniPixmap)
#define ANI_PIXMAP_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, ani_pixmap_get_type (), AniPixmapClass)
#define GTK_IS_ANI_PIXMAP(obj)       GTK_CHECK_TYPE (obj, ani_pixmap_get_type ())


typedef struct _AniPixmap       AniPixmap;
typedef struct _AniPixmapClass  AniPixmapClass;

typedef struct _AniItem	AniItem;
struct _AniPixmap
{
  GtkMisc misc;

  GList *grim;
  GList *current;
  gboolean running;
  gboolean clear;
};

struct _AniPixmapClass
{
  GtkMiscClass parent_class;
};

struct _AniItem 
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	gint duration;
	guint leftpos, toppos;
};


guint      ani_pixmap_get_type   (void);
GtkWidget* ani_pixmap_new        (GList *item);
GList *    ani_pixmap_get        (AniPixmap  *pixmap);
int 		ani_run(AniPixmap *pixmap);
void 		ani_stop(AniPixmap *pixmap);
void ani_start(AniPixmap *pixmap);
void ani_toggle(AniPixmap *pixmap);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ANI_PIXMAP_H__ */
