#ifndef __ANSITERM_H__
#define __ANSITERM_H__

#include <gtk/gtkwidget.h>
#include <gtk/gtkadjustment.h>

#define MAX_ARGS 15
#define ESC 27

#define ATTR_BOLD 1
#define ATTR_REVERSE 2
/* blink attr is ignored */
#define ATTR_BLINK 4
#define ATTR_UNDER 8
#define ATTR_SELECTION 16

#define linenumber(l) (((l) + term->visible_line_begin)%term->saved_lines)
#define CURRENT_BYTE(term) (term->buf + linenumber(term->cu_y)*term->col \
		+ term->cu_x)
#define CURRENT_COLOR(term) (term->color + linenumber(term->cu_y)*term->col \
		+ term->cu_x)
#define CURRENT_ATTR(term) (term->attr + linenumber(term->cu_y)*term->col \
		+ term->cu_x)

#define CUR_APL 1
#define EDITOR_BUTTON 2
enum {
	TERM_COLOR_BLACK,
	TERM_COLOR_RED,
	TERM_COLOR_GREEN,
	TERM_COLOR_YELLOW,
	TERM_COLOR_BLUE,
	TERM_COLOR_MAGENTA,
	TERM_COLOR_CYAN,
	TERM_COLOR_WHITE,
	TERM_COLOR_CURSOR_FG,
	TERM_COLOR_CURSOR_BG,
	TERM_COLOR_I_SELECT,
	TERM_COLOR_END
};

typedef struct _AnsiTerm AnsiTerm;
typedef struct _AnsiTermClass AnsiTermClass;

typedef int (*ToTermFunc)(AnsiTerm *, char *buf, int nbytes);
typedef int (*FromTermFunc)(char *buf, int nbytes);

typedef struct _KeyMap KeyMap;
typedef void (*KeyMapFunc)(gpointer);
struct _KeyMap {
	int keyval;
	int state; /* state of mouse */
	gpointer data;
	KeyMapFunc func;
};

struct  _AnsiTerm {
	GtkWidget widget;
	GtkAdjustment *adjustment;
	guint32 timer;

	GdkGC *gc;
	GdkFont *font;
	GdkGC *white_gc;
	GdkGC *black_gc;
	GdkGC *bg_gc;
	GdkGC *cursor_gc;
	GdkGC *i_sel_gc;

	GdkColor **color_table;
	guchar *buf;
	guchar *attr;
	guchar *color;
	guchar state;
	guchar cu_fg, old_fg;
	guchar cu_bg, old_bg;
	guchar normal_fg, normal_bg;
	guchar cu_attr, old_attr;
	guchar cu_x, old_x;
	gchar cu_y, old_y;
	guchar top, bot;
	guchar col, row;
	guchar argc;
	guchar max_reached;
	guint16 saved_lines;
	guint16 visible_line_begin;
	guint16 real_visible_line_begin;
	guint16 argv[MAX_ARGS];
	guchar font_height;
	guchar font_width;
	guchar font_ascent;
	gboolean use_bold, use_under, auto_linefeed, silent, draw_flag;
	gboolean can_block, need_slide_update;
	gboolean have_bgpixmap;
	ToTermFunc to_term;
	FromTermFunc from_term;
	GList *keymap_list;
	char charset;
	int mode;
	char *tmp_str;
	int tmp_alloc, tmp_len;
        GdkIC     *ic;
        GdkICAttr *ic_attr;
};

struct _AnsiTermClass {
	GtkWidgetClass parent_class;
	void (*size_changed) (AnsiTerm *term);
	void (*line_changed) (AnsiTerm *term);
	void (*received) (AnsiTerm *term);
	void (*set_scroll_adjustments) (AnsiTerm *term, 
		GtkAdjustment *hadj, GtkAdjustment *vadj);
};

#define ANSI_TERM(w) ((AnsiTerm *)w)
GtkWidget * ansi_term_new(char *terminal_font, int col, int row, 
	int saved_lines, 
	ToTermFunc to_term, FromTermFunc from_term);
void keymap_init(AnsiTerm *);
void ansi_term_expose_line(AnsiTerm *term, int y, int x1, int x2);
void ansi_term_show_cursor(AnsiTerm *term);
void ansi_term_hide_cursor(AnsiTerm *term);
void ansi_term_reset(AnsiTerm *term);
void ansi_term_flush(AnsiTerm *term);
void ansi_term_sane(AnsiTerm *term);
void ansi_term_queue_draw(AnsiTerm *term);
gint ansi_term_key_press(GtkWidget *w, GdkEventKey *ev);
void ansi_term_set_size(AnsiTerm *term, int new_col, int new_row);
int ansi_term_selection_clear(GtkWidget *w, GdkEventSelection *ev);
void ansi_term_selection_handler (GtkWidget *widget, GtkSelectionData *selection_data, guint info, guint time);
int ansi_term_adjustment_changed(GtkAdjustment *adj, AnsiTerm *term);


#endif /*  __ANSITERM_H__ */
