
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include <ctype.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gau.h"
#include "gauchat.h"
#include "scrolledchat.h"
#include "config.h"

GtkWidget *chat_control_box = NULL;
GauScrolledChat *schat = NULL;
char *chat_prefix1 = NULL;
char *chat_prefix2 = NULL;
char *chat_suffix = NULL;
gboolean chat_append = FALSE;

void chat_binding_prepare(GauChat * chat);
static void flush_cb(GauChat * chat, char *buf, int len);
static void chat_add_choose_cb(GtkWidget * w, GauChat * chat);
static void chat_add_head_choose_cb(GtkWidget * w, GauChat * chat);
static void chat_add_cb(GtkWidget * w, GauChat * chat);
static int chat_ctrl_z(GauChat * chat, GdkEventKey * ev, AnsiTerm * term);

static void flush_cb(GauChat * chat, char *buf, int len)
{
    extern gint crlf;
    term->from_term(buf, len);
    if (crlf == 0) {
	term->from_term("\r", 1);
    } else if (crlf == 2) {
	term->from_term("\n", 1);
    } else if (crlf == 1) {
	term->from_term("\r\n", 2);
    }
}

void chat_cb(GtkWidget * w, gpointer data)
{
	//g_print("chat_cb: term size: %d\n", term->col);
    if (schat) {
	if (schat->visible) {
	    gtk_widget_hide (schat->win);
	    if (chat_control_box) gtk_widget_hide (chat_control_box);
	    ansi_term_set_size (term, term->col, term->row + 5);
	    gtk_widget_grab_focus (GTK_WIDGET(term));
	    schat->visible = FALSE;
	} else {
	    ansi_term_set_size (term, term->col, term->row - 5);
	    gtk_widget_show (schat->win);
	    if (chat_control_box) gtk_widget_show (chat_control_box);
	    gtk_widget_grab_focus (GTK_WIDGET(schat->chat));
	    schat->visible = TRUE;
	}
	return;
    }
	//printf("c: col: %d\n", term->col);
    schat = gau_scrolled_chat_new(term->font, term->font_height,
				  term->font_ascent, term->col, 30, 5,
				  (gpointer) flush_cb);
    if (chat_prefix1)
	gau_chat_prefix_set(schat->chat, chat_prefix1, 1);
    if (chat_prefix2)
	gau_chat_prefix_set(schat->chat, chat_prefix2, 2);
    if (chat_suffix)
	gau_chat_suffix_set(schat->chat, chat_suffix);
    ansi_term_set_size (term, term->col, term->row - 5);
    gtk_box_pack_end (GTK_BOX(term_box), schat->win, FALSE, FALSE, 0);
    gtk_widget_show (schat->win);
    gtk_widget_grab_focus (GTK_WIDGET(schat->chat));
    gtk_signal_connect(GTK_OBJECT(schat->chat), "key_press_event",
		       GTK_SIGNAL_FUNC(chat_ctrl_z), term);
    schat->visible = TRUE;
    chat_binding_prepare(schat->chat);
    if (chat_append) {
	GtkWidget *button;
	chat_control_box = gtk_vbox_new(TRUE, 0);

	button = gtk_button_new_with_label(" ");
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	gtk_box_pack_start(GTK_BOX(chat_control_box), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(chat_add_cb), schat->chat);

	button = gtk_button_new_with_label(" ");
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	gtk_box_pack_start(GTK_BOX(chat_control_box), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		     GTK_SIGNAL_FUNC(chat_add_choose_cb), schat->chat);

	button = gtk_button_new_with_label("Ӹ1");
	GTK_WIDGET_UNSET_FLAGS(button, GTK_CAN_FOCUS);
	gtk_box_pack_start(GTK_BOX(chat_control_box), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(chat_add_head_choose_cb), schat->chat);
	gtk_box_pack_start (GTK_BOX(control_box), chat_control_box, FALSE, FALSE, 1);
	gtk_widget_show_all (chat_control_box);
    }
}

void chat_binding_prepare(GauChat * chat)
{
    static guchar *bindstring[20] =
    {0};
    static int init = TRUE;
    FILE *fp;
    guchar *buf;
    int i, index;
    if (init) {
	char *filename;
	init = FALSE;
	filename = g_strconcat (expand_path(gau_path), "/chat-binding", NULL);
	fp = fopen(filename, "r");
	g_free (filename);
	if (fp == NULL)
	    return;
	while ((buf = get_line(fp)) != NULL) {
	    buf++;
	    if (!isdigit(buf[0])) {
		g_warning("parse error in %s\n", filename);
		continue;
	    }
	    index = *buf++ - '0';
	    if (isdigit(*buf)) {
		index = 10 * index + *buf++ - '0';
	    }
	    index--;
	    bindstring[index] = replace_ctl_char(strchr(buf + 1, '"') + 1);
	}
    }
    for (i = 0; i < 20; i++) {
	if (bindstring[i])
	    chat->fbinding[i] = bindstring[i];
    }
}

void choose_ok_cb(GtkWidget * w, GauChat * chat)
{
    GtkEntry *entry_prefix, *entry_suffix;
    entry_prefix = gtk_object_get_data(GTK_OBJECT(w), "entry_prefix1");
    gau_chat_prefix_set(chat, gtk_entry_get_text(entry_prefix), 1);
    entry_prefix = gtk_object_get_data(GTK_OBJECT(w), "entry_prefix2");
    gau_chat_prefix_set(chat, gtk_entry_get_text(entry_prefix), 2);
    entry_suffix = gtk_object_get_data(GTK_OBJECT(w), "entry_suffix");
    gau_chat_suffix_set(chat, gtk_entry_get_text(entry_suffix));
    destroy_top_level(w);
}

static void chat_add_head_choose_cb(GtkWidget * w, GauChat * chat)
{
    GtkLabel *label = GTK_LABEL(GTK_BUTTON(w)->child);
    if (chat->add == -1)
	chat->add = -2;
    else if (chat->add == -2)
	chat->add = -1;
    else if (chat->add == 1)
	chat->add = 2;
    else if (chat->add == 2)
	chat->add = 1;
    if (chat->add == -1 || chat->add == 1) {
	gtk_label_set_text (label, "Ӹ1");
    } else {
	gtk_label_set_text (label, "Ӹ2");
    }
}

static void chat_add_choose_cb(GtkWidget * w, GauChat * chat)
{
    static GtkWidget *win;
    GtkWidget *button;

    GtkWidget *hbox, *vbox, *label;
    GtkWidget *entry_prefix1, *entry_prefix2, *entry_suffix;

    win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_position(GTK_WINDOW(win), GTK_WIN_POS_CENTER);
    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(win), vbox);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);

    label = gtk_label_new("Ӹ1");
    gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 2);

    entry_prefix1 = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry_prefix1), chat->prefix1);
    gtk_box_pack_end(GTK_BOX(hbox), entry_prefix1, FALSE, FALSE, 2);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);

    label = gtk_label_new("Ӹ2");
    gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 2);

    entry_prefix2 = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry_prefix2), chat->prefix2);
    gtk_box_pack_end(GTK_BOX(hbox), entry_prefix2, FALSE, FALSE, 2);

    hbox = gtk_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
    label = gtk_label_new("");
    gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 2);

    entry_suffix = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry_suffix), chat->suffix);
    gtk_box_pack_end(GTK_BOX(hbox), entry_suffix, FALSE, FALSE, 2);

    gtk_widget_new(gtk_hseparator_get_type(),
		   "GtkWidget::parent", vbox,
		   NULL);
    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);

    button = gtk_button_new_with_label("OK");
    gtk_object_set_data(GTK_OBJECT(button), "entry_prefix1", entry_prefix1);
    gtk_object_set_data(GTK_OBJECT(button), "entry_prefix2", entry_prefix2);
    gtk_object_set_data(GTK_OBJECT(button), "entry_suffix", entry_suffix);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(choose_ok_cb), chat);
    gtk_box_pack_end(GTK_BOX(hbox), button,
		     TRUE, TRUE, 2);

    button = gtk_button_new_with_label("");
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(destroy_top_level), NULL);
    gtk_box_pack_end(GTK_BOX(hbox), button,
		     TRUE, TRUE, 2);
    gtk_window_set_transient_for (GTK_WINDOW(win), GTK_WINDOW(gtk_widget_get_toplevel(w)));
    gtk_widget_show_all(win);
    gtk_grab_add(win);
}

static void chat_add_cb(GtkWidget * w, GauChat * chat)
{
    chat->add = -chat->add;
    if (chat->add > 0) {
	gtk_label_set_text (GTK_LABEL(GTK_BIN(w)->child), " Ŀ");
    } else {
	gtk_label_set_text (GTK_LABEL(GTK_BIN(w)->child), " ");
    }
}

static int chat_ctrl_z(GauChat * chat, GdkEventKey * ev, AnsiTerm * term)
{
    if (ev->keyval == 'z' && (ev->state & GDK_CONTROL_MASK) && chat->current_x == 0) {
	term->from_term("", 1);
	return TRUE;
    } else if (ev->keyval == 'c' && (ev->state & GDK_MOD1_MASK)) {
	chat_cb (GTK_WIDGET(chat), NULL);
	return TRUE;
    }
    return FALSE;
}
