#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "gau.h"

#include "checked.xpm"
static GdkPixmap *check_pixmap;
static GdkBitmap *check_mask;


static gint phonebook_new(char *);

/* phone book control callback */
static void phone_add_cb(GtkWidget * w);
static void phone_remove_cb(GtkWidget * w);
static void phone_edit_cb(GtkWidget * w);
static void phone_close_cb(GtkWidget * w);
static void phone_save_cb(GtkWidget * w);
static void phone_call_cb(GtkWidget * w);
static void phone_select_cb(GtkWidget * w);
static void phone_check_toggle_cb(GtkWidget * w, gint row,
				  gint column, GdkEventButton *);
static GtkWidget *phone_control_button(const char *,
				       GtkSignalFunc func,
				       gpointer phone,
				       GtkWidget * container);
static GtkWidget *phone = NULL;
static int phone_current_row;
static GtkWidget *edit_entry[4];

/* public function */

/* ȭȣοִ ȣ  ش */
gint
phone_row(void)
{
    return GTK_CLIST(phone)->rows;
}

/* row ִ ȭ   ش */
/* return: 0  1                   */
gint
phone_info_update(int row, PhoneInfo * pi)
{
    if (row < 0 || row >= phone_row())
	return FALSE;
    gtk_clist_get_text(GTK_CLIST(phone), row, 1, &pi->name);
    gtk_clist_get_text(GTK_CLIST(phone), row, 2, &pi->number);
    gtk_clist_get_text(GTK_CLIST(phone), row, 3, &pi->speed);
    gtk_clist_get_text(GTK_CLIST(phone), row, 4, &pi->script);
    return TRUE;
}

/* ǥõ  ȣ ε ش */
gint
phone_get_next_checked_number(int current_row)
{
    int i;
    gint is_checked;

    for (i = current_row + 1; i < phone_row(); i++) {
	is_checked = GPOINTER_TO_INT(gtk_clist_get_row_data(GTK_CLIST(phone), i));
	if (is_checked)
	    return i;
    }
    for (i = 0; i <= current_row; i++) {
	is_checked = GPOINTER_TO_INT(gtk_clist_get_row_data(GTK_CLIST(phone), i));
	if (is_checked)
	    return i;
    }
    return -1;
}

void phone_hide(void)
{
    gtk_widget_hide(gtk_widget_get_toplevel(phone));
}

void phone_check_by_name(char *name)
{
    int i;
    gchar *phone_name;

    for (i = 0; i < phone_row(); i++) {
	gtk_clist_get_text(GTK_CLIST(phone), i, 1, &phone_name);
	if (strcmp(phone_name, name) == 0) {
	    gtk_clist_set_pixmap(GTK_CLIST(phone), i, 0,
				 check_pixmap, check_mask);
	    gtk_clist_set_row_data(GTK_CLIST(phone), i, GINT_TO_POINTER(1));
	} else {
	    gtk_clist_set_text(GTK_CLIST(phone), i, 0, "");
	    gtk_clist_set_row_data(GTK_CLIST(phone), i, GINT_TO_POINTER(0));
	}
    }
}

void phone_win_show(void)
{
    phone_win(expand_path(PHONE_LIST));
}

gint
phone_win(char *phonelist)
{
    GtkWidget *top;
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *swin;

    if (phone) {
	gtk_widget_show(gtk_widget_get_toplevel(phone));
	return TRUE;
    }
    if (!phonebook_new(phonelist)) {
	return FALSE;
    }
    top = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_transient_for(GTK_WINDOW(top), GTK_WINDOW(main_win)); 
    gtk_window_set_position(GTK_WINDOW(top), GTK_WIN_POS_CENTER);
    gtk_window_set_title(GTK_WINDOW(top), "ȭ ɱ");
    gtk_signal_connect(GTK_OBJECT(top), "delete_event",
		       GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete), NULL);
    gtk_container_set_border_width(GTK_CONTAINER(top), 5);

    vbox = gtk_vbox_new(FALSE, 4);
    gtk_container_add(GTK_CONTAINER(top), vbox);

    //gtk_widget_set_usize (phone, GTK_CLIST (phone)->clist_window_width, 200);
    swin = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
				      GTK_POLICY_AUTOMATIC, 
				      GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (swin), phone);
    gtk_box_pack_start(GTK_BOX(vbox), swin, TRUE, TRUE, 5);

    /* separator */
    gtk_widget_new(gtk_hseparator_get_type(),
		   "GtkWidget::parent", vbox,
		   "GtkWidget::visible", TRUE,
		   NULL);

    /* phonebook control box */
    hbox = gtk_hbox_new(TRUE, 5);
    gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    phone_control_button("ȭɱ",
			 GTK_SIGNAL_FUNC(phone_call_cb), phone, hbox);
    phone_control_button("",
			 GTK_SIGNAL_FUNC(phone_select_cb), phone, hbox);
    phone_control_button("ݱ",
			 GTK_SIGNAL_FUNC(phone_close_cb), phone, hbox);

    /* one more box */
    hbox = gtk_hbox_new(TRUE, 5);
    gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    phone_control_button("߰",
			 GTK_SIGNAL_FUNC(phone_add_cb), phone, hbox);
    phone_control_button("",
			 GTK_SIGNAL_FUNC(phone_remove_cb), phone, hbox);
    phone_control_button("",
			 GTK_SIGNAL_FUNC(phone_save_cb), phone, hbox);
    phone_control_button("",
			 GTK_SIGNAL_FUNC(phone_edit_cb), phone, hbox);

    gtk_widget_show_all(top);

    return TRUE;
}

/* private function */


static gint
 phonebook_new(char *phonebook_file)
{
    gchar *items[5];
    char title[5][256];
    char *titles[5];
    int i;
    int width[5], t_width;
    int ret;

    GdkColor *bg = NULL;
    FILE *fp;

    fp = fopen(phonebook_file, "r");
    if (fp == NULL) {
	g_warning("cannot find phone book file %s", phonebook_file);
	return FALSE;
    }
    ret = fscanf(fp, "%d %d %d %d %d\n", width, width + 1,
		 width + 2, width + 3, width + 4);
    if (ret != 5) {
	g_warning("invalid format");
	return FALSE;
    }
    t_width = 0;
    for (i = 0; i < 5; i++) {
	t_width += width[i];
	ret = fscanf(fp, "%s\n", title[i]);
	titles[i] = title[i];
	if (ret != 1) {
	    g_warning("invalid format in phonebook");
	    return FALSE;
	}
    }

    phone = gtk_clist_new_with_titles(5, titles);
    //gtk_clist_set_border(GTK_CLIST(phone), GTK_SHADOW_ETCHED_OUT);
    gtk_widget_set_usize(phone, t_width + 80, 200);
    gtk_clist_column_titles_passive(GTK_CLIST(phone));
    gtk_clist_set_selection_mode(GTK_CLIST(phone), GTK_SELECTION_BROWSE);
    gtk_signal_connect(GTK_OBJECT(phone), "select_row",
		       GTK_SIGNAL_FUNC(phone_check_toggle_cb), NULL);
    for (i = 0; i < 5; i++) {
	gtk_clist_set_column_width(GTK_CLIST(phone), i, width[i]);
	gtk_clist_set_column_justification(GTK_CLIST(phone), i,
					   GTK_JUSTIFY_LEFT);
    }

    check_pixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, 
    	gtk_widget_get_colormap(phone), &check_mask, bg, (char **)checked_data);

    gtk_clist_freeze(GTK_CLIST(phone));
    items[0] = "";
    while (1) {
	char phone_line[256];
	char *s;
	ret = fscanf(fp, "%s\n", phone_line);
	if (ret <= 0)
	    break;
	s = phone_line;
	items[1] = strtok(s, ";:");
	for (i = 2; i < 5; i++) {
	    s = strtok(NULL, ";:");
	    items[i] = s;
	}
	gtk_clist_append(GTK_CLIST(phone), items);
    }
    gtk_clist_thaw(GTK_CLIST(phone));
    fclose(fp);
    return TRUE;
}

static GtkWidget *
phone_edit_entry(char *name, GtkWidget * vbox)
{
    GtkWidget *label, *entry;
    GtkWidget *hbox;

    hbox = gtk_hbox_new(FALSE, 8);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);

    label = gtk_label_new(name);
    gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
    gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
    entry = gtk_entry_new();
    gtk_box_pack_end(GTK_BOX(hbox), entry, FALSE, FALSE, 0);

    return entry;
}


static void phone_edit_ok_cb(GtkWidget * w, gpointer data)
{
    int i;

    for (i = 1; i < 4; i++) {
	gtk_clist_set_text(GTK_CLIST(phone), phone_current_row, i,
		       gtk_entry_get_text(GTK_ENTRY(edit_entry[i - 1])));
    }
    destroy_top_level (w);
}

static void phone_edit_cb(GtkWidget * w)
{
    GtkWidget *win = NULL;
    GtkWidget *vbox, *hbox;
    GtkWidget *frame;
    char *name, *phone_number, *speed, *script;

    win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(win), "ȭȣ ");
    gtk_window_set_position(GTK_WINDOW(win), GTK_WIN_POS_MOUSE);
    gtk_container_set_border_width(GTK_CONTAINER(win), 5);
    gtk_grab_add(win);

    frame = gtk_frame_new(NULL);
    gtk_container_add(GTK_CONTAINER(win), frame);

    vbox = gtk_vbox_new(TRUE, 8);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 8);
    gtk_container_add(GTK_CONTAINER(frame), vbox);
    gtk_widget_show(vbox);

    edit_entry[0] = phone_edit_entry("̸:", vbox);
    gtk_clist_get_text(GTK_CLIST(phone), phone_current_row, 1, &name);
    gtk_entry_set_text(GTK_ENTRY(edit_entry[0]), name);

    edit_entry[1] = phone_edit_entry("ȭȣ:", vbox);
    gtk_clist_get_text(GTK_CLIST(phone), phone_current_row, 2,
		       &phone_number);
    gtk_entry_set_text(GTK_ENTRY(edit_entry[1]), phone_number);

    edit_entry[2] = phone_edit_entry("ۼӵ:", vbox);
    gtk_clist_get_text(GTK_CLIST(phone), phone_current_row, 3, &speed);
    gtk_entry_set_text(GTK_ENTRY(edit_entry[2]), speed);

    edit_entry[3] = phone_edit_entry("ȥڸ:", vbox);
    gtk_clist_get_text(GTK_CLIST(phone), phone_current_row, 4, &script);
    gtk_entry_set_text(GTK_ENTRY(edit_entry[3]), script);

    gtk_widget_new(gtk_hseparator_get_type(),
		   "GtkWidget::parent", vbox,
		   NULL);

    hbox = gtk_hbox_new(TRUE, 5);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);
    gtk_widget_new(gtk_button_get_type(),
		   "GtkButton::label", "Ȯ",
		   "GtkObject::signal::clicked", phone_edit_ok_cb, NULL,
		   "GtkWidget::parent", hbox,
		   NULL);
    gtk_widget_new(gtk_button_get_type(),
		   "GtkButton::label", "",
		   "GtkObject::signal::clicked", destroy_top_level, NULL,
		   "GtkWidget::parent", hbox,
		   NULL);
    gtk_widget_show_all(win);
}

static void phone_close_cb(GtkWidget * w)
{
    gtk_widget_hide(gtk_widget_get_toplevel(w));
}

static void phone_add_cb(GtkWidget * w)
{
    gchar *items[5];
    int i;

    items[0] = "";
    for (i = 1; i < 5; i++) {
	gtk_clist_get_text(GTK_CLIST(phone), phone_current_row, i, &items[i]);
    }

    gtk_clist_insert(GTK_CLIST(phone), phone_current_row + 1, items);
}

static void phone_remove_cb(GtkWidget * w)
{
    gtk_clist_remove(GTK_CLIST(phone), phone_current_row);
}

static void phone_save_cb(GtkWidget * w)
{
    FILE *fp;
    GtkCListColumn *column;
    GList *clist_row;
    char *phonebook_name;
    int row;
    int i;

    phonebook_name = g_strconcat(expand_path(GAU_PATH), "/phonelist", NULL);
    fp = fopen(phonebook_name, "w");
    g_free (phonebook_name);

    if (fp == NULL) {
	g_warning("can't open to write phone book (%s)", phonebook_name);
	return;
    }

    row = GTK_CLIST(phone)->rows;
    column = GTK_CLIST(phone)->column;

    fprintf(fp, "%d %d %d %d %d\n", column[0].width, column[1].width,
	    column[2].width, column[3].width, column[4].width);

    for (i = 0; i < 5; i++) {
	fprintf(fp, "%s\n", column[i].title);
    }
    clist_row = GTK_CLIST(phone)->row_list;
    for (i = 0; i < row; i++) {
	GtkCListRow *clist_data = clist_row->data;
	fprintf(fp, "%s:%s:%s:%s\n",
		GTK_CELL_TEXT(clist_data->cell[1])->text,
		GTK_CELL_TEXT(clist_data->cell[2])->text,
		GTK_CELL_TEXT(clist_data->cell[3])->text,
		GTK_CELL_TEXT(clist_data->cell[4])->text);
	clist_row = clist_row->next;
    }
    fclose(fp);
}

static void phone_call_cb(GtkWidget * w)
{
    dial_begin();
}

static void phone_select_cb(GtkWidget * w)
{
    int is_checked;
    is_checked = !gtk_clist_get_row_data(GTK_CLIST(phone), phone_current_row);
    if (is_checked) {
	gtk_clist_set_pixmap(GTK_CLIST(phone), phone_current_row, 0,
			     check_pixmap, check_mask);
    } else {
	gtk_clist_set_text(GTK_CLIST(phone), phone_current_row, 0, "");
    }
    gtk_clist_set_row_data(GTK_CLIST(phone), phone_current_row,
			   GINT_TO_POINTER(is_checked));
}

static void phone_check_toggle_cb(GtkWidget * w, gint row, gint column,
				  GdkEventButton * bevent)
{
    phone_current_row = row;
    if (column < 0)
	return;
    phone_current_row = row;
    phone_select_cb(w);
}

GtkWidget *
phone_control_button(const char *name, GtkSignalFunc func,
	             gpointer data, GtkWidget * box)
{
    return gtk_widget_new (GTK_TYPE_BUTTON,
    			  "label", name,
			  "can_focus", FALSE,
			  "signal::clicked", func, data,
			  "parent", box,
			  NULL);
}

