
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <gmodule.h>

#include "gau.h"
#include "config.h"

typedef int (*ISelectSearch) (char *buf, int x, int *vs, int *ve);
typedef void (*ISelectAction) (void);
typedef void (*ISelectCancel) (void);

typedef struct 
{
	ISelectSearch search;
	ISelectAction action;
	ISelectAction cancel;
} PatternMatcher;

static char i_sel_buf[1024];

static void i_sel_show(AnsiTerm *term);
static void i_sel_hide(AnsiTerm *term);
static void translate(AnsiTerm *term, int *x, int *y);

static int i_sel_focus;
static int i_sel_found;

static int visual_row, visual_start, visual_end;
static int n_patterns = 0;
static PatternMatcher *patterns;
static PatternMatcher *current_pattern;
static void send_from_term(char *buf);
int register_patterns(PatternMatcher **ret_patterns, void (*fn)(char *));


void
i_select_init(void)
{
#if 0
	GModule *handle;
	int (*register_patterns)(PatternMatcher **, void (*fn)(char *));
	if (!g_module_supported) return;

	handle = g_module_open("./IS.so", G_MODULE_BIND_LAZY); //dlopen("./IS.so", RTLD_LAZY);
	if (!handle) {
		handle = g_module_open(expand_path("~/.gau/IS.so"), G_MODULE_BIND_LAZY);
	}
	if (!handle) {
		handle = g_module_open(IS_MODULE_NAME, G_MODULE_BIND_LAZY);
	}
	if (!handle) {
	    handle = g_module_open("IS.so", G_MODULE_BIND_LAZY);
	}
	
	if (!handle) {
		g_warning ("cannot open IS.so\n");
		return;
	}
	if (!g_module_symbol(handle, "register_patterns", (gpointer *)&register_patterns)) {
	    g_warning ("cannot find register_patterns in IS.so: %s", g_module_error());
	    return;
	}
#endif
	n_patterns = register_patterns(&patterns, send_from_term);
}

void
i_select_motion(AnsiTerm *term, int x, int y)
{
	if (!i_sel_found) {
		visual_end++;
	    return;
	}

	translate(term, &x, &y);
	if(i_sel_focus) {
		if(visual_row != y || visual_start > x || visual_end < x) {
			i_sel_hide(term);
		} 
	} else {
		if(visual_row == y && visual_start <= x && visual_end >= x) {
			i_sel_show(term);
		}
	}
}

void
i_select_end(AnsiTerm *term, int x, int y)
{
	if (!i_sel_found) {
		if (visual_start == visual_end)
		    send_from_term(NULL);
	    return;
	}

	if (i_sel_focus) {
		play_click();
		i_sel_hide(term);
		(*current_pattern->action)();
	} else {
		(*current_pattern->cancel)();
	}
}

void
i_sel_show(AnsiTerm *term)
{
	i_sel_focus = TRUE;
	gdk_gc_set_foreground(term->i_sel_gc, term->color_table[TERM_COLOR_I_SELECT]);
	gdk_draw_rectangle(GTK_WIDGET(term)->window, term->i_sel_gc, TRUE,
		visual_start * term->font_width,
		visual_row * term->font_height,
		(visual_end - visual_start)* term->font_width,
		term->font_height);
	gdk_gc_set_foreground(term->i_sel_gc, &GTK_WIDGET(term)->style->black);
	gdk_draw_text(GTK_WIDGET(term)->window, term->font, term->i_sel_gc, 
		visual_start * term->font_width, 
		visual_row * term->font_height + term->font_ascent,
		term->buf + linenumber(visual_row)*term->col + visual_start, 
		visual_end - visual_start);
}

void
i_sel_hide(AnsiTerm *term)
{
	GdkRectangle area;
	i_sel_focus = FALSE;
	area.x = visual_start * term->font_width; 
	area.y = visual_row * term->font_height;
	area.width = (visual_end - visual_start)* term->font_width;
	area.height = term->font_height;
	gtk_widget_draw(GTK_WIDGET(term), &area);
}

void
send_from_term(char *buf)
{
	extern AnsiTerm *term;
	char c[2] = "\r";
	static guint32 oldtime =0;
	guint32 newtime;
	int len;

	newtime = gdk_time_get();
	if (oldtime + 300 > newtime) {
		oldtime = newtime;
		return;
	}
	oldtime = newtime;
	len = buf ? strlen(buf) : 0;
	if (len)
	    term->from_term(buf, len);
	term->from_term(c, 1);
}

int
i_select_begin(AnsiTerm *term, int x, int y)
{
	int i;

	i_sel_focus = TRUE;
	translate(term, &x, &y);
	visual_row = y;

	memcpy(i_sel_buf, term->buf + linenumber(visual_row)*term->col, term->col);
	i_sel_buf[term->col] = 0;

	for (i = 0; i < n_patterns; i++) {
		if (patterns[i].search(i_sel_buf, x, &visual_start, &visual_end)) {
			i_sel_found = TRUE;
			i_sel_show(term);
			current_pattern = &patterns[i];
			return TRUE;
		}
	}
	i_sel_found = FALSE;
	visual_start = visual_end = 0;
	return FALSE;
}

void
translate(AnsiTerm *term, int *x, int *y)
{
	if(*x < 0) *x = 0;
	*x = *x / term->font_width;
	if(*x >= term->col) *x = term->col -1;;
	if(*y < 0) *y = 0;
	*y = *y / term->font_height;
	if(*y >= term->row) *y = term->row -1;
}
