
/* this file is a part of gau software, (C) Hwang chi-deok 1997-1999      */

#include "config.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <ctype.h>

#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "anipixmap.h"
#include "gau.h"
gboolean sound_flag = TRUE;
gboolean use_beep = FALSE;
gboolean silent = FALSE;
char *gau_path = NULL;
char *sound_path = NULL;
char *p_string = NULL;
int capture_fd = -1;
int scapture_fd = -1;
gboolean strip_linefeed = FALSE;
int idle_guard_interval = 120 * 1000;
char *idle_guard_string = " ";
int dial_waiting_interval = 30*1000;
char *play_command = NULL;
gboolean use_ztelnet = 0;
gboolean use_under = FALSE;
gboolean use_bold = FALSE;
gboolean vi_esc_hack = TRUE;
char *sz_command = NULL;
char *rz_command = NULL;
char *telnet_command = NULL;
char *capture_path = NULL;	/* will be initialized at gau_config */
char *script_path = NULL;
char *down_path = NULL;
char *up_path = NULL;
char *capture_file = NULL;
guint32 last_incoming_time = -1;
int logo_file_number = FLAG_NUM;
char *logo_file = FLAG_NAME;

GdkColor *black = NULL;
GdkColor *red = NULL;
GdkColor *green = NULL;
GdkColor *yellow = NULL;
GdkColor *blue = NULL;
GdkColor *magenta = NULL;
GdkColor *cyan = NULL;
GdkColor *white = NULL;
GdkColor *cursor_fg = NULL;
GdkColor *cursor_bg = NULL;

static void capture_file_select(void);
static void capture_file_selection_ok(GtkWidget * w, GtkWidget * win);


void popup_center_mouse(GtkWidget * win);
void popup_center(GtkWidget * win, GtkWidget * ref);
void popup_center_position(GtkWidget * win, int x, int y);

void popup_center(GtkWidget * win, GtkWidget * ref)
{
    int x, y, width, height;
    gdk_window_get_geometry(ref->window, &x, &y, &width, &height, NULL);
    if (GTK_WIDGET_NO_WINDOW(ref)) {
	x += ref->allocation.x + ref->allocation.width / 2;
	y += ref->allocation.y + ref->allocation.height / 2;
    } else {
	x += width / 2;
	y += height / 2;
    }

    popup_center_position(win, x, y);
}

void popup_center_mouse(GtkWidget * win)
{
    int x, y;
    gdk_window_get_pointer(NULL, &x, &y, NULL);

    popup_center_position(win, x, y);
}

void popup_center_position(GtkWidget * win, int x, int y)
{
    int win_width, win_height;
    GtkRequisition requisition;

    if (win->parent) {
	g_warning("widget is not window");
	return;
    }
    //g_print("%d %d\n", x, y);
    gtk_widget_size_request(win, &requisition);
    win_width = requisition.width;
    win_height = requisition.height;
    x = x - win_width / 2;
    y = y - win_height / 2;
    //g_print("%d %d\n", x, y);



    if (x < 0)
	x = 0;
    else if (x > gdk_screen_width() - win_width) {
	x = gdk_screen_width() - win_width;
    }
    if (y < 0)
	y = 0;
    else if (y > gdk_screen_height() - win_height) {
	y = gdk_screen_height() - win_height;
    }
    gtk_widget_set_uposition(win, x, y);
    gtk_widget_show(win);
}





static int
substr (char *s1, char *s2)
{
    return !strncmp (s1, s2, strlen(s2));
}

char *
expand_path(char *str)
{
    static char buf[1024];
    if (str[0] == '~' && str[1] == '/') {
	strcpy(buf, g_get_home_dir());
	strcat(buf, str + 1);
	return buf;
    } else {
	return str;
    }
}

char *
get_line(FILE * fp)
{
    int len, tlen;
    static char *buf = NULL;
    static int size = 0;
    int conti = FALSE;

    if (size == 0) {
	size = 125;
	buf = g_new(char, size);
    }
    tlen = 0;
    while (fgets(buf + tlen, size - tlen - 1, fp) != NULL) {
	if (buf[tlen] == '#')
	    continue;
	if (conti) {
	    guchar *s;
	    s = buf + tlen;
	    if (isspace(*s)) {
		while (isspace(*s))
		    s++;
		memmove(buf + tlen, s, strlen(s) + 1);
	    }
	}
	if (buf[tlen] == '\n' || buf[tlen] == 0) {
	    if (conti)
		break;
	    else {
		continue;
	    }
	}
	conti = FALSE;
	len = strlen(buf + tlen);
	if (len == (size - tlen - 2)) {
	    // incomplete read. we need to increase buf size.
	    // or eof
	    tlen += len;
	    size += 125;
	    buf = g_realloc(buf, size);
	} else {
	    tlen += len;
	    if (buf[tlen - 1] == '\n') {
		tlen--;
		buf[tlen] = 0;
	    } else {
		if (tlen == (size - 1)) {
		    size += 125;
		    buf = g_realloc(buf, size);
		}
		continue;
	    }
	    if (buf[tlen - 1] == '\\' && buf[tlen - 2] != '\\') {
		conti = TRUE;
		tlen--;
		buf[tlen] = 0;
		continue;
	    } else {
		break;
	    }
	}
    }
    if (tlen == 0)
	return NULL;
    else
	return buf;
}


void 
play_connect(void)
{
    play("connect.wav");
}

void 
play_transfer_end(void)
{
    play("transfer.wav");
}

void 
play_exit(void)
{
    play("end.wav");
}

void 
play_click(void)
{
    if (use_beep)
	return;
    play("click.wav");
}

void 
play_disconnect(void)
{
    play("disconec.wav");
}

void 
play(char *filename)
{
    int pid;
    char *play;
    if (use_beep) {
	gdk_beep();
	gdk_beep();
	return;
    }
    if (sound_flag == FALSE)
	return;
    play = g_strconcat(play_command, " ", expand_path(sound_path), "/", filename, NULL);
    pid = fork();
    if (pid == 0) {
	int fd = open("/dev/null", O_WRONLY);
	dup2(fd, 1);
	// child
	execlp("sh", "sh", "-c", play, NULL);
	g_warning("fail to run '%s'", play);
	_exit(1);
    } else if (pid < 0) {
	g_warning("fail to fork in %s", __FUNCTION__);
    }
    g_free (play);
}

GtkWidget *
ani_pixmap_create(GtkWidget *parent)
{
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    AniItem *item;
    GList *list = NULL;
    int i;
    char filename[256];
    GdkColor *bg = NULL;

    for (i = 0; i < logo_file_number; i++) {
	g_snprintf(filename, sizeof(filename), "%s/xpm/%s.xpm.%d",
		expand_path(gau_path), logo_file, i);
	pixmap = gdk_pixmap_colormap_create_from_xpm(NULL, gtk_widget_get_colormap(parent), &mask,
					    bg, filename);
	if (pixmap == NULL) {
	    g_warning("xpm file open error: %s", filename);
	    return NULL;
	}
	item = g_new(AniItem, 1);
	item->pixmap = pixmap;
	item->mask = mask;
	item->duration = 500;
	list = g_list_append(list, item);
    }
    return ani_pixmap_new(list);
}

static gboolean taegeuk_running = FALSE;

void 
taegeuk_start(void)
{
    ani_start(ANI_PIXMAP(taegeuk));
    taegeuk_running = TRUE;
}

void 
taegeuk_stop(void)
{
    ani_stop(ANI_PIXMAP(taegeuk));
    taegeuk_running = FALSE;
}

void
taegeuk_toggle (void)
{
    if (taegeuk_running) taegeuk_stop();
    else taegeuk_start();
}

char *
get_string(guchar *buf)
{
    char *s;
    if (!isspace(*buf)) {
	while (!isspace(*buf))
	    buf++;
    }
    buf = eat_space(buf);
    if (buf[0] == '"') {
	s = strchr(buf + 1, '"');
	if (s != NULL)
	    *s = 0;
	return replace_ctl_char(buf + 1);
    }
    s = strchr(buf, ')');
    if (s != NULL)
	*s = 0;
    return replace_ctl_char(buf);
}

int 
get_boolean(char *buf)
{
    if (strstr(buf, "tr") || strstr(buf, "on"))
	return TRUE;
    if (strstr(buf, "fa") || strstr(buf, "off"))
	return FALSE;
    return -1;
}

GdkColor *
color_new(float red, float green, float blue)
{
    GdkColor *color;
    color = g_new(GdkColor, 1);
    color->red = red * 65535.0;
    color->green = green * 65535.0;
    color->blue = blue * 65535.0;
    return color;
}

GdkColor *
get_color(guchar * s)
{
    float red, green, blue;
    if (!isspace(*s))
	while (!isspace(*++s));
    s = eat_space(s);
    sscanf(s, "%f %f %f", &red, &green, &blue);
    return color_new(red, green, blue);
}

int 
get_int(guchar * s)
{
    int i;
    if (!isspace(*s))
	while (!isspace(*++s));
    s = eat_space(s);
    sscanf(s, "%d", &i);
    return i;
}

void 
gau_config(void)
{
    FILE *fp;
    char *s;
    char tmpbuf[1024];


    /* gtk resource parsing */
    gtk_rc_parse(expand_path(GTK_RC_FILE));

    /* one more parsing for gau's resource with the same file */
    fp = fopen(expand_path(RC_FILE), "r");
    if (fp == NULL) {
	g_warning("fail to open gau's resource file '%s'",
		  expand_path(RC_FILE));
	g_warning("gau will use hardcoded default settings");
	goto def;
    }
    while (fgets(tmpbuf, 1024, fp) != NULL) {
	if (tmpbuf[0] != '(')
	    continue;
	/* This line is gau's option */
	s = eat_space(tmpbuf + 1);
	if (substr(s, "device")) {
	    if (modem_device)
		continue;	// set from command line

	    modem_device = get_string(s);
	    //g_print("device: '%s'\n", modem_device);
	} else if (strncmp(s, "baud", 4) == 0) {
	    modem_speed = get_string(s);
	    //g_print("baud: '%s'\n", modem_speed);
	} else if (strncmp(s, "parity", 6) == 0) {
	    modem_parity = get_string(s);
	    //g_print("parity: '%s'\n", modem_parity);
	} else if (strncmp(s, "bits", 4) == 0) {
	    modem_bits = get_string(s);
	    //g_print("bits: '%s'\n", modem_bits);
	} else if (strncmp(s, "use_hwf", 7) == 0) {
	    modem_use_hwf = get_boolean(s + 7);
	    //g_print("use_hwf: %d\n", modem_use_hwf);
	} else if (strncmp(s, "use_swf", 7) == 0) {
	    modem_use_swf = get_boolean(s + 7);
	    //g_print("use_swf: %d\n", modem_use_swf);
	} else if (strncmp(s, "logo-layer-number", 10) == 0) {
	    logo_file_number = get_int (s);
	} else if (strncmp(s, "logo", 4) == 0) {
	    logo_file = get_string(s);
	} else if (strncmp(s, "script_path", 11) == 0) {
	    script_path = get_string(s);
	} else if (strncmp(s, "capture_path", 12) == 0) {
	    capture_path = get_string(s);
	} else if (strncmp(s, "capture_file", 12) == 0) {
	    capture_file = get_string(s);
	    //g_print("capture_path: '%s'\n", capture_path);
	} else if (strncmp(s, "down_path", 9) == 0) {
	    down_path = get_string(s);
	} else if (strncmp(s, "up_path", 7) == 0) {
	    up_path = get_string(s);
	} else if (strncmp(s, "do_lock", 7) == 0) {
	    do_lock = get_boolean(s + 7);
	} else if (strncmp(s, "saved_lines", 11) == 0) {
	    saved_lines = get_int(s);
	    // g_print("saved_lines: %d\n", saved_lines);
	} else if (strncmp(s, "use_sound", 9) == 0) {
	    sound_flag = get_boolean(s + 9);
	} else if (strncmp(s, "use_beep", 8) == 0) {
	    use_beep = get_boolean(s + 8);
	} else if (strncmp(s, "sound_path", 10) == 0) {
	    sound_path = get_string(s);
	} else if (strncmp(s, "column", 6) == 0) {
	    col = get_int(s);
	    if (col <= 20 || col >= 120)
		col = 82;
	} else if (strncmp(s, "row", 3) == 0) {
	    row = get_int(s);
	    if (row <= 5 || row >= 50)
		row = 26;
	} else if (strncmp(s, "terminal_font", 13) == 0) {
	    terminal_font = get_string(s);
	} else if (strncmp(s, "play_command", 12) == 0) {
	    play_command = get_string(s);
	} else if (strncmp(s, "silent", 6) == 0) {
	    silent = get_boolean(s + 6);
	    if (silent == -1)
		silent = FALSE;
	} else if (strncmp(s, "black", 5) == 0) {
	    black = get_color(s);
	} else if (strncmp(s, "red", 3) == 0) {
	    red = get_color(s);
	} else if (strncmp(s, "blue", 4) == 0) {
	    blue = get_color(s);
	} else if (strncmp(s, "green", 5) == 0) {
	    green = get_color(s);
	} else if (strncmp(s, "yellow", 6) == 0) {
	    yellow = get_color(s);
	} else if (strncmp(s, "cyan", 4) == 0) {
	    cyan = get_color(s);
	} else if (strncmp(s, "white", 5) == 0) {
	    white = get_color(s);
	} else if (strncmp(s, "magenta", 7) == 0) {
	    magenta = get_color(s);
	} else if (strncmp(s, "background", 10) == 0) {
	    normal_bg = get_int(s);
	} else if (strncmp(s, "foreground", 10) == 0) {
	    normal_fg = get_int(s);
	} else if (substr(s, "idle_interval") || substr (s, "idle-time")) {
	    idle_guard_interval = get_int(s) * 1000;
	} else if (substr(s, "dial_waiting_interval")) {
	    dial_waiting_interval = get_int(s) * 1000;
	} else if (substr (s, "sz-command") || substr (s, "sz_command")) {
	    sz_command = get_string(s);
	} else if (substr (s, "rz-command") || substr (s, "rz_command")) {
	    rz_command = get_string(s);
	} else if (substr (s, "telnet_command")) {
	    telnet_command = get_string(s);
	} else if (substr (s, "use_bold")) {
	    use_bold = get_boolean(s);
	} else if (substr (s, "use_underline")) {
	    use_under = get_boolean(s);
	} else if (strncmp(s, "initialize_string", 17) == 0) {
	    initialize_string = get_string(s);
	} else if (substr (s, "idle_guard_string")) {
	    idle_guard_string = get_string(s);
	} else if (strncmp(s, "strip_linefeed", 14) == 0) {
	    strip_linefeed = get_boolean(s);
	} else if (strncmp(s, "chat_append", 11) == 0) {
	    chat_append = get_boolean(s);
	} else if (strncmp(s, "chat_prefix1", 12) == 0) {
	    chat_prefix1 = get_string(s);
	} else if (strncmp(s, "chat_prefix2", 12) == 0) {
	    chat_prefix2 = get_string(s);
	} else if (strncmp(s, "chat_suffix", 11) == 0) {
	    chat_suffix = get_string(s);
	} else if (strncmp(s, "editor", 6) == 0) {
	    editor = get_string(s);
	} else if (strncmp(s, "sh_command", 10) == 0) {
	    sh_command = get_string(s);
	} else if (strncmp(s, "can_block", 9) == 0) {
	    can_block = get_boolean(s);
	} else if (strncmp(s, "read_hack", 9) == 0) {
	    read_hack = get_boolean(s);
	} else if (strncmp(s, "p_string", 8) == 0) {
	    p_string = get_string(s);
	} else if (strncmp(s, "cursor-fg", 9) == 0) {
	    cursor_fg = get_color(s);
	} else if (strncmp(s, "cursor-bg", 9) == 0) {
	    cursor_bg = get_color(s);
	} else {
	    g_warning("parsing error : %s", tmpbuf);
	}
    }
  def:

    if (capture_path == NULL)
	capture_path = CAPTURE_PATH;
    if (down_path == NULL)
    	down_path = DOWN_PATH;
    if (up_path == NULL)
    	down_path = DOWN_PATH;
    if (terminal_font == NULL)
	terminal_font = DEFAULT_TERMINAL_FONT;
    if (script_path == NULL)
	script_path = SCRIPT_PATH;
    if (sound_path == NULL)
	sound_path = DEFAULT_SOUND_PATH;
    if (gau_path == NULL)
	gau_path = GAU_PATH;
    if (play_command == NULL)
	play_command = DEFAULT_PLAY_COMMAND;
    if (sz_command == NULL)
	sz_command = DEFAULT_SZ_COMMAND;
    if (rz_command == NULL)
	rz_command = DEFAULT_RZ_COMMAND;

    if (telnet_command == NULL)
	telnet_command = DEFAULT_TELNET_COMMAND;
    if (*telnet_command == 'z')
	use_ztelnet = TRUE;
    else
	use_ztelnet = FALSE;

    if (p_string == NULL)
	p_string = "p\r";
    if (editor == NULL)
	editor = DEFAULT_EDITOR;
    if (sh_command == NULL)
	sh_command = DEFAULT_SH;
    if (sound_flag)
	use_beep = FALSE;
    // color setup
    if (!black)
	black = color_new(0, 0, 0);
    if (!red)
	red = color_new(0.7, 0, 0);
    if (!green)
	green = color_new(0, 0.7, 0);
    if (!yellow)
	yellow = color_new(0.5, 0.5, 0);
    if (!blue)
	blue = color_new(0, 0, 0.7);
    if (!magenta)
	magenta = color_new(0.5, 0, 0.5);
    if (!cyan)
	cyan = color_new(0, 0.5, 0.5);
    if (!white)
	white = color_new(0.83, 0.80, 0.93);
    if (!cursor_fg)
	cursor_fg = white;
    if (!cursor_bg)
	cursor_bg = black;
    fclose(fp);
}

// buf_siz     ȭ  Ѵ.

#define BUF_SIZ 80*6
char inputbuf[BUF_SIZ];
void 
fast_input_handler(gpointer data, int source,
  			         GdkInputCondition con)
{
    int size, newsize;
    typedef int (*FilterFunc) (char *str, int bytes);
    GList *list = input_filter_list;
    long lf;
    static guint32 last_time = 0;
    guint32 this_time;
    show_incoming(TRUE);
    // Ʒ  250 70  33.6K𵩿 ߾ Ӵϴ.
    // ٸ ӵ  ׿  ִ   ӵ
    //    ֽϴ.
    this_time = gdk_time_get();
    size = read(source, inputbuf, BUF_SIZ);
    if (size < 0) {
	/* FIXME*/
	/* something wrong, probably pipe broken */
	gdk_input_remove(read_input_tag);
	read_fd = -1;
	return;
    } else if (size == 0) {
	gdk_input_remove(read_input_tag);
	read_fd = -1;
	return;
    }
    if (this_time - last_time < 250) {
	while (1) {
	    usleep(70);
	    ioctl(source, FIONREAD, &lf);
	    if (lf == 0)
		break;
	    newsize = read(source, inputbuf + size, BUF_SIZ - size);
	    //g_print("%d\n", newsize);
	    if (newsize <= 0)
		break;
	    size += newsize;
	    if (size >= BUF_SIZ)
		break;
	}
	last_time = gdk_time_get();
    } else {
	last_time = this_time;
    }

    while (list) {
	FilterFunc func;
	func = list->data;
	list = list->next;
	size = (*func) (inputbuf, size);
	if (!size)
	    return;		// eaten

    }
    if (remote_echo) {
	int i;
	char c = '\n';
	for (i = 0; i < size; i++) {
	    if (inputbuf[i] != '\r') {
		term->from_term(inputbuf + i, 1);
	    } else {
		term->from_term(inputbuf + i, 1);
		term->from_term(&c, 1);
	    }
	}
    }
    term->to_term(term, inputbuf, size);
    show_incoming(FALSE);
    last_incoming_time = gdk_time_get();
}


void 
input_handler(gpointer data, int source, GdkInputCondition con)
{
    int size;
    typedef int (*FilterFunc) (char *str, int bytes);
    GList *list = input_filter_list;
    show_incoming(TRUE);
    size = read(source, inputbuf, BUF_SIZ);
    if (size < 0) {
	/* something wrong, probably pipe broken */
	gdk_input_remove(read_input_tag);
	read_fd = -1;
	return;
    } else if (size == 0) {
	gdk_input_remove(read_input_tag);
	read_fd = -1;
	return;
    }
    while (list) {
	FilterFunc func;
	func = list->data;
	list = list->next;
	size = (*func) (inputbuf, size);
	if (!size)
	    return;		// eaten

    }
    if (remote_echo) {
	int i;
	char c = '\n';
	for (i = 0; i < size; i++) {
	    if (inputbuf[i] != '\r') {
		term->from_term(inputbuf + i, 1);
	    } else {
		term->from_term(inputbuf + i, 1);
		term->from_term(&c, 1);
	    }
	}
    }
    term->to_term(term, inputbuf, size);
    show_incoming(FALSE);
    last_incoming_time = gdk_time_get();
}
#undef BUF_SIZ

void 
gau_hangup(void)
{
    if (use_modem)
	modem_hangup();
    else
	telnet_hangup();
}

int 
capture_input_filter(char *str, int bytes)
{
    int i;
    if (strip_linefeed) {
	for (i = 0; i < bytes; i++)
	    if (str[i] != '\r')
		write(capture_fd, str + i, 1);
    } else
	write(capture_fd, str, bytes);
    return bytes;
}

void 
begin_capture(const char *filename)
{
    if (strcmp (filename, "screen") == 0) {
	screen_save_cb(NULL, NULL);
	return;
    } else if (strcmp (filename, "wholescreen") == 0) {
	screen_save_cb(NULL, GINT_TO_POINTER(1));
	return;
    }
    if (capture_fd > 0)
	return;
    if (filename == NULL || filename[0] == 0) {
	time_t timep = time(NULL);
	char buf[256];
	struct tm *lt = localtime(&timep);
	g_snprintf(buf, sizeof(buf), "%s/%02d%02d%02d.cap", expand_path(capture_path),
		lt->tm_year, lt->tm_mon + 1, lt->tm_mday);
	capture_fd = open(buf, O_WRONLY | O_CREAT | O_APPEND, 0660);
	if (capture_fd == -1) {
	    g_warning("can't open capture file %s", buf);
	    return;
	}
    } else if (strcmp(filename, "query") == 0) {
	capture_file_select();
	return;
    } else {
	char *buf;

	if (filename[0] == '/')
	    buf = g_strdup (filename);
	else
	    buf = g_strconcat (expand_path(capture_path), "/", filename, NULL);
	capture_fd = open(buf, O_WRONLY | O_CREAT | O_APPEND, 0660);
	g_free (buf);
	if (capture_fd < 0) {
	    g_warning("can't open capture file %s", buf);
	    return;
	}
    }
    input_filter_list = g_list_append(input_filter_list, capture_input_filter);
    gtk_label_set_text (GTK_LABEL(GTK_BIN(capture_button)->child), "");
}

static void 
capture_file_select(void)
{
    GtkWidget *file_selection;
    char *capture_path_dir;
    file_selection = gtk_file_selection_new(" ");
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file_selection));
    capture_path_dir = g_strconcat (capture_path, "/", NULL);
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(file_selection), 
    				    capture_path_dir);
    g_free (capture_path_dir);
    gtk_window_set_position(GTK_WINDOW(file_selection), GTK_WIN_POS_CENTER);
    gtk_signal_connect(
	       GTK_OBJECT(GTK_FILE_SELECTION(file_selection)->ok_button),
			  "clicked",
			  GTK_SIGNAL_FUNC(capture_file_selection_ok),
			  file_selection);
    gtk_signal_connect_object(
	   	GTK_OBJECT(GTK_FILE_SELECTION(file_selection)->cancel_button),
			  "clicked",
			  GTK_SIGNAL_FUNC(gtk_widget_destroy),
			  (GtkObject *)file_selection);
    gtk_widget_show(file_selection);
}

static void capture_file_selection_ok(GtkWidget * w, GtkWidget * win)
{
    char *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(win));
    //g_print("filename: %s\n", filename);
    begin_capture(filename);
    gtk_widget_destroy(win);
}


void 
end_capture(void)
{
    input_filter_list = g_list_remove(input_filter_list, capture_input_filter);
    close(capture_fd);
    gtk_label_set_text (GTK_LABEL(GTK_BIN(capture_button)->child), "");
    capture_fd = -1;
}


void 
screen_save(void)
{
    char *buf;
    char c = '\n';
    int i;
    int byte;

    for (i = 0; i < term->max_reached; i++) {
	buf = term->buf + linenumber(i) * term->col;
	byte = term->col - 1;
	while (byte >= 0) {
	    if (buf[byte] != ' ')
		break;
	    byte--;
	}
	byte++;
	write(scapture_fd, buf, byte);
	write(scapture_fd, &c, 1);
    }
    close(scapture_fd);
}

void
whole_screen_save (void)
{
    char *buf;
    char c = '\n';
    int i;
    int byte;
    int row_offset = term->adjustment->value;

    for (i = 0; i <= row_offset + term->max_reached; i++) {
	buf = term->buf + linenumber(i-row_offset+term->saved_lines) * term->col;
	byte = term->col - 1;
	while (byte >= 0) {
	    if (buf[byte] != ' ')
		break;
	    byte--;
	}
	byte++;
	write(scapture_fd, buf, byte);
	write(scapture_fd, &c, 1);
    }
    close(scapture_fd);
}

int 
delayed_real_run(void (*func) (void))
{
    (*func) ();
    return FALSE;
}

void 
delayed_run(guint32 msec, void (*func) (void))
{
    gtk_timeout_add(msec, (GtkFunction) delayed_real_run, (gpointer) func);
}


int
is_first_han(char *buf, int x)
{
    int xx;
    if (x < 0) return 0;
    xx = x;
    if(*(buf + x) & 0x80) {
	do { 
	    x--;
	} while(x >= 0 && *(buf + x) & 0x80);
	if((xx - x)%2 == 1) return 1;
    } 
    return 0;
}

int
is_second_han(char *buf, int x)
{
    int xx;
    if (x < 1) return 0;
    xx = x;
    if(*(buf + x) & 0x80) {
	do { 
	    x--;
	} while(x >= 0 && *(buf + x) & 0x80);
	if((xx - x)%2 == 0) return 1;
    } 
    return 0;
}
