#ifndef __GZILLA_IMAGE_H__
#define __GZILLA_IMAGE_H__

#include "gzillaimgsink.h"

typedef struct _GzillaImgSinkImg GzillaImgSinkImg;

struct _GzillaImgSinkImg {
  GzillaImgSink imgsink;
  GtkWidget *widget;

  /* parameters of the preview widget */
  gint width;
  gint height;
  /* alt goes here if we implement it */
  gint32 bg_color;

  guchar *linebuf;
  gint draw_idle_tag;
  gint idle_counter;

  /* the tag for the signal handler connected to the widget's destroy signal */
  gint destroy_tag;

  /* parameters of the input imgsink */
  gint in_width;
  gint in_height;
  GzillaImgType in_type;
  guchar *cmap;
  gint num_colors;
  /* don't need bg_index because the cmap already has the background
     color substituted. */
};

GzillaImgSink *gzilla_image_new (gint width,
				 gint height,
				 const char *alt,
				 gint32 bg_color);
GtkWidget*
gzilla_image_widget (GzillaImgSink *imgsink);

#endif /* __GZILLA_IMAGE_H__ */
