
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include "config.h"

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <string.h>

#ifdef HAVE_TERMIOS_H
#include <termios.h>
#else
#include <sgtty.h>
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>
#ifdef DECL_ERRNO
extern int errno;
#endif

#include <assert.h>

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include <signal.h>

#include <gtk/gtk.h>
#include "ansiterm.h"
#include "gau.h"

int connected = FALSE;
int remove_filter;

FILE *log_file;
gboolean modem_use_hwf = -1;
gboolean modem_use_swf = -1;
gboolean do_lock = FALSE;
char *modem_device = NULL;
char *modem_speed = NULL;
char *modem_parity = NULL;
char *modem_bits = NULL;
char *initialize_string = NULL;


struct termios tp;
struct termios tmpp;

/* ---| Modem Parameters |--------------------------------------------------- */

int m_getdcd(int fd)
/* Get the data carrier detect.      */
/* i.e. tells if we are connected.   */
/* this is platform depended (sorry) */
{
    unsigned int value;
    ioctl(fd, TIOCMGET, &value);
    return (value & TIOCM_CAR) ? TRUE : FALSE;
}

/* should all be POSIX */

/* Drop DTR line and raise it again. */
/* Used to hangup. */
void m_dtrtoggle(int fd)
{
    struct termios tty, old;
    /* Posix - set baudrate to 0 and back */
    tcgetattr(fd, &tty);
    tcgetattr(fd, &old);
    cfsetospeed(&tty, B0);
    cfsetispeed(&tty, B0);
    tcsetattr(fd, TCSANOW, &tty);
    sleep(1);
    tcsetattr(fd, TCSANOW, &old);
}

void modem_hangup(void)
{
    m_dtrtoggle(read_fd);
}

void m_setparms(int fd, char *baudr, char *par, char *bits, int hwf, int swf)
/* Set baudrate, parity and number of bits. */
{
    int spd = -1;
    int newbaud;
    int bit = bits[0];

    struct termios tty;

    tcgetattr(fd, &tty);

    /* Check if 'baudr' is really a number */
    if ((newbaud = (atol(baudr) / 100)) == 0 && baudr[0] != '0')
	newbaud = -1;

    switch (newbaud) {
    case 0:
	spd = B0;
	break;
    case 3:
	spd = B300;
	break;
    case 6:
	spd = B600;
	break;
    case 12:
	spd = B1200;
	break;
    case 24:
	spd = B2400;
	break;
    case 48:
	spd = B4800;
	break;
    case 96:
	spd = B9600;
	break;
    case 192:
	spd = B19200;
	break;
    case 384:
	spd = B38400;
	break;
    case 576:
	spd = B57600;
	break;
    case 1152:
	spd = B115200;
	break;
    }

    if (spd != -1) {
	cfsetospeed(&tty, (speed_t) spd);
	cfsetispeed(&tty, (speed_t) spd);
    }
    switch (bit) {
    case '5':
	tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS5;
	break;
    case '6':
	tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS6;
	break;
    case '7':
	tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS7;
	break;
    case '8':
    default:
	tty.c_cflag = (tty.c_cflag & ~CSIZE) | CS8;
	break;
    }
    /* Set into raw, no echo mode */
    tty.c_iflag = IGNBRK;
    tty.c_lflag = 0;
    tty.c_oflag = 0;
    tty.c_cflag |= CLOCAL | CREAD;
    tty.c_cc[VMIN] = 1;
    tty.c_cc[VTIME] = 1;

    if (swf)
	tty.c_iflag |= IXON | IXOFF;
    else
	tty.c_iflag &= ~(IXON | IXOFF | IXANY);

    tty.c_cflag &= ~(PARENB | PARODD);
    if (par[0] == 'E' || par[0] == 'e')
	tty.c_cflag |= PARENB;
    if (par[0] == 'O' || par[0] == 'o')
	tty.c_cflag |= PARODD;

    if (hwf)
	tty.c_cflag |= CRTSCTS;
    else
	tty.c_cflag &= ~CRTSCTS;

    tcsetattr(fd, TCSANOW, &tty);
}

void modem_setbaud(int fd, char *baudr)
{
    int newbaud;
    int spd = -1;
    struct termios tty;
    tcgetattr(fd, &tty);

    /* Check if 'baudr' is really a number */
    if ((newbaud = (atol(baudr) / 100)) == 0 && baudr[0] != '0')
	newbaud = -1;

    switch (newbaud) {
    case 0:
	spd = B0;
	break;
    case 3:
	spd = B300;
	break;
    case 6:
	spd = B600;
	break;
    case 12:
	spd = B1200;
	break;
    case 24:
	spd = B2400;
	break;
    case 48:
	spd = B4800;
	break;
    case 96:
	spd = B9600;
	break;
    case 192:
	spd = B19200;
	break;
    case 384:
	spd = B38400;
	break;
    case 576:
	spd = B57600;
	break;
    case 1152:
	spd = B115200;
	break;
    default:
	g_warning("Invalid baud %d in %s\n", newbaud, __FUNCTION__);
	break;
    }

    if (spd != -1) {
	cfsetospeed(&tty, (speed_t) spd);
	cfsetispeed(&tty, (speed_t) spd);
    }
    tcsetattr(fd, TCSANOW, &tty);
}


int modem_lock(char *device)
{
    char s[255], lockbuf[128], temp[10];
    int handle, i, pid;
    struct stat buf;
    if (device == NULL)
	device = modem_device;
    strcpy(temp, strrchr(device, '/') + 1);
    g_snprintf(s, sizeof(s), "%s/LCK..%s", LOCK_PATH, temp);
    if (stat(s, &buf) == 0) {
	if ((handle = open(s, O_RDONLY)) == -1)
	    return FALSE;
	i = read(handle, &lockbuf, sizeof(lockbuf));
	close(handle);
	if (i > 0) {
	    lockbuf[i] = 0;
	    sscanf(lockbuf, "%d", &pid);
	    if (pid > 0 && kill(pid, 0) < 0 && errno == ESRCH) {
		unlink(s);
	    } else
		return FALSE;
	}
    }
    if ((handle = open(s, O_CREAT | O_WRONLY | O_EXCL)) == -1)
	return FALSE;
    fchmod(handle, S_IWRITE | S_IREAD | S_IRGRP | S_IROTH);

    g_snprintf(s, sizeof(s), "%010d\n", getpid());
    write(handle, s, strlen(s));
    close(handle);
    return TRUE;
}

int modem_unlock(char *device)
{
    char s[256], temp[256];
    if (device == NULL)
	device = modem_device;
    strcpy(temp, strrchr(device, '/') + 1);
    g_snprintf(s, sizeof(s), "%s/LCK..%s", LOCK_PATH, temp);
    if (unlink(s) == -1)
	return FALSE;
    return TRUE;
}

void modem_send_break(void)
{
    if (read_fd < 0)
	return;
    tcsendbreak(read_fd, 0);
}

/* 
   flag = TRUE:  hangup phone when program exits 
   FALSE: don't hangup phone when program exits if connected 
 */
int modem_sethup(int flag)
{
    if (read_fd < 0)
	return -1;
    if (tcgetattr(read_fd, &tmpp) == -1)
	return -1;
    if (flag)
	tmpp.c_cflag |= HUPCL;
    else
	tmpp.c_cflag &= ~HUPCL;
    tcsetattr(read_fd, TCSANOW, &tmpp);
    return 0;
}

// flag = TRUE: use software flow control XON/XOFF

int modem_setxon(int flag)
{
    if (read_fd < 0)
	return -1;
    if (tcgetattr(read_fd, &tmpp) == -1)
	return -1;
    if (flag) {
	tmpp.c_iflag |= IXON;
	tmpp.c_cflag &= ~CRTSCTS;
    } else {
	tmpp.c_iflag &= ~(IXON | IXOFF | IXANY);
	tmpp.c_cflag |= CRTSCTS;
    }
    tcsetattr(read_fd, TCSANOW, &tmpp);
    return 0;
}

/* open modem device and initialize modem setting */
int modem_init(void)
{
    /* setup modem */
    if (!modem_device) {
	modem_device = DEFAULT_MODEM;
    }
    if (access(modem_device, F_OK) != 0) {
	fprintf(stderr, "Ͻ  ̽ġ ʽϴ\n");
	fprintf(stderr, "'%s' ִ ȮϽʽÿ\n", modem_device);
	exit(1);
    }
    if (access(modem_device, R_OK | W_OK) != 0) {
	fprintf(stderr, "'%s'  а   ϴ.\n", modem_device);
	fprintf(stderr, "ڿ а  㰡 Ǿִ ȮϽ\n");
	fprintf(stderr, "׷ ʴٸ chmod ̿ؼ  ڿ\n");
	fprintf(stderr, "а   ֽʽÿ\n");
	fprintf(stderr, "Ʈ α Ͻ  chmod a+rw %s\n", modem_device);
	exit(1);
    }
    read_fd = open(modem_device, O_RDWR);
    if (read_fd < 0) {
	g_print("gau: fail to open modem device (%s)\n", modem_device);
	g_print("Please check whether there is another process that uses modem.\n");
	g_print("If you want telnet-mode, You must run 'gaui', not 'gau'.\n");
	exit(1);
    }
    if (tcgetattr(read_fd, &tp) != 0) {
	g_print("gau: fail to get status of modem\n");
	g_print("Please check whether there is another process that uses modem.\n");
	exit(1);
    }
    if (!modem_speed) {
	modem_speed = DEFAULT_SPEED;
    }
    if (!modem_parity) {
	modem_parity = "NO";
    }
    if (!modem_bits) {
	modem_bits = "8";
    }
    if (modem_use_hwf < 0)
	modem_use_hwf = 1;
    if (modem_use_swf < 0)
	modem_use_swf = 0;
    m_setparms(read_fd, modem_speed, modem_parity, modem_bits,
	       modem_use_hwf, modem_use_swf);
    connected = modem_connected();
    gtk_timeout_add(TIME_TICK_INTERVAL, modem_check_connected, NULL);

    if (!initialize_string)
	initialize_string = DEFAULT_INITIALIZATION;

    modem_write(initialize_string, strlen(initialize_string));
    if (do_lock)
	modem_lock(NULL);
    return TRUE;
}

int modem_connected(void)
{
    if (read_fd == -1)
	return FALSE;
    return m_getdcd(read_fd);
}

int modem_restore(void)
{
    tcsetattr(read_fd, TCSANOW, &tp);
    return 1;
}

int modem_write(char *str, int size)
{
    /*
       char *s;
       int i;
       while((s = strchr(str, '\r'))) {
       i = s + 1 - str;
       write(read_fd, str, i);
       str = s + 1;
       byte -= i;
       }
     */
    last_out_time = gdk_time_get();
    if (local_echo) {
	int i;
	char c = '\n';
	for (i = 0; i < size; i++) {
	    if (str[i] != '\r') {
		term->to_term(term, str + i, 1);
	    } else {
		term->to_term(term, str + i, 1);
		term->to_term(term, &c, 1);
	    }
	}
    }
    write(read_fd, str, size);
    return TRUE;
}

int modem_read(char *str, int byte)
{
    byte = read(read_fd, str, byte);
    return byte;
}


int modem_check_connected(gpointer foo)
{
    static int tick;
    static guint32 connect_time;
    int i;
    guint32 current_time;
    GList *list;
    typedef void SimpleFunction(void);
    if (connected != modem_connected()) {
	connected = !connected;
	if (connected) {
	    time_t timep;
	    struct tm *lt;
	    tick = -1;
	    connect_time = gdk_time_get();
	    show_message("ȭ Ǿϴ");
	    fprintf(log_file, "=====================================================\n");
	    if (pi.name) {
		fprintf(log_file, "%s: %s\n", pi.name, pi.number);
	    } else {
		update_bottom_menu_from_file(NULL);
		fprintf(log_file, "ϾȵȰ\n");
	    }
	    timep = time(NULL);
	    lt = localtime(&timep);
	    fprintf(log_file, ":%02d %02d %02d %02d %02d",
		    lt->tm_mon + 1, lt->tm_mday,
		    lt->tm_hour, lt->tm_min, lt->tm_sec);
	    fflush(log_file);
	    gtk_widget_set_sensitive(write_button, TRUE);
	    gtk_label_set_text (GTK_LABEL(GTK_BIN(call_button)->child), "ȭ");
	    list = connected_function_list;
	    while (list) {
		SimpleFunction *func = list->data;
		//g_print("connected fun: %p\n", list->data);
		(*func) ();
		list = list->next;
	    }
	} else {
	    fprintf(log_file, "ȭð:%02d %02d\n", tick / 60, tick % 60);
	    fflush(log_file);
	    tick++;
	    show_message("ȭ ϴ. ̹ ȭð %d %dԴϴ",
		    tick / 60, tick % 60);
	    gau_set_title(NULL);
	    gtk_label_set_text (GTK_LABEL(GTK_BIN(call_button)->child), 
	    	"ȭɱ");
	    if (gau_state == GAU_SCRIPT)
		script_cancel();
	    gau_state = GAU_NOTHING;
	    /*
	       * restore default speed of modem
	     */
	    modem_setbaud(read_fd, modem_speed);
	    list = disconnected_function_list;
	    while (list) {
		SimpleFunction *func = list->data;
		// g_print("disconnected fun: %p\n", list->data);
		(*func) ();
		list = list->next;
	    }
	    pi.name = NULL;
	    last_out_time += 80000000L;
	}
    }
    if (connected) {
	current_time = gdk_time_get();
	if ((last_out_time + idle_guard_interval) < current_time) {
	    term->from_term(idle_guard_string, strlen(idle_guard_string));
	}
	if (current_time - 500 > last_incoming_time) {
	    auto_response_check(term->buf + term->col * linenumber(term->cu_y),
				term->cu_x);
	    last_incoming_time = current_time + 400000;
	}
	i = (current_time - connect_time) / 1000;
	if (i != tick) {
	    tick = i;
	    show_time(tick);
	}
    }
    return TRUE;
}
