/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MY_MENU_BAR_H__
#define __MY_MENU_BAR_H__


#include <gdk/gdk.h>
#include <gtk/gtkmenushell.h>
#include <gtk/gtkmenubar.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MY_MENU_BAR(obj)          GTK_CHECK_CAST (obj, my_menu_bar_get_type (), GtkMenuBar)
#define MY_MENU_BAR_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, my_menu_bar_get_type (), GtkMenuBarClass)
#define MY_IS_MENU_BAR(obj)       GTK_CHECK_TYPE (obj, my_menu_bar_get_type ())


typedef struct _MyMenuBar       MyMenuBar;
typedef struct _MyMenuBarClass  MyMenuBarClass;

struct _MyMenuBar
{
  GtkMenuBar menu_bar;
};

struct _MyMenuBarClass
{
  GtkMenuBarClass parent_class;
};


guint      my_menu_bar_get_type (void);
GtkWidget* my_menu_bar_new      (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_MENU_BAR_H__ */
