
/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998, 1999  */
#include "config.h"

#include <gtk/gtk.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include "gau.h"

enum {
    WAITFOR,
    WAITFOR_MULTI,
    TRANSMIT,
    SETTITLE,
    SETIDLETIME,
    BOTTOMMENU,
    SLEEP,
    BEEP,
    GOTO,
    LABEL,
    PLAY,
    CAPTURE_ON,
    BAUDRATE,
    CAPTURE_OFF,
    DISCONNECT,
    SETPSTRING,
    RUN,
    INCLUDE,
    END
};

typedef struct _Script Script;
struct _Script {
    int type;
    gpointer *arg;
};

static GList *current_script_item = NULL;
static GList *telnet_script = NULL;

static char *wait_string = NULL;
static int waitfor_timeout_tag = 0;
static gboolean waitfor_waiting = FALSE;

static guint idle_tag = 0;
static guint sleep_tag = 0;
static gboolean script_capture_active = FALSE;

static GList *make_script_from_file(char *filename);
static GList *make_script_from_string(char *str);
static GList *make_script_from_command(char *command);

static void end_script(void);
static int waitfor_filter(char *buf, int size);
static int waitfor_timeout(gpointer data);
static int next_script(void);
static void script_bottom_menu_update(char *menu_file);
static void run_telnet_login_script(void);
static GList *include_script(GList * list, Script * script);
static int mextract_string(char *src, char *des);

void install_next_script(void)
{
    gau_state = GAU_SCRIPT;
    idle_tag = gtk_timeout_add(0, (GtkFunction)next_script, NULL);
}

void waitfor(char *buf, int second)
{

    input_filter_list = g_list_append(input_filter_list, waitfor_filter);

    if (wait_string)
	g_free(wait_string);
    wait_string = g_strdup(buf);
    waitfor_filter(wait_string, -1);	// initialize

    waitfor_waiting = TRUE;

    show_message("\"%s\" ٸϴ", wait_string);

    if (second > 0)
	waitfor_timeout_tag = gtk_timeout_add(second, waitfor_timeout, NULL);
}

int 
waitfor_timeout(gpointer data)
{
    waitfor_waiting = FALSE;
    input_filter_list = g_list_remove(input_filter_list, waitfor_filter);
    if (current_script_item->next == NULL) {
	end_script();
    } else {
	current_script_item = current_script_item->next;
	install_next_script();
    }
    waitfor_timeout_tag = 0;
    return FALSE;
}

int 
waitfor_filter(char *buf, int size)
{
    int i;
    static char *wait_string_p;
    if (size < 0) {
	wait_string_p = buf;
	return 0;
    }
    for (i = 0; i < size; i++) {
	if (buf[i] != *wait_string_p)
	    wait_string_p = wait_string;
	else if (*++wait_string_p == '\0') {
	    input_filter_list =
		g_list_remove(input_filter_list, waitfor_filter);
	    waitfor_waiting = FALSE;
	    if (waitfor_timeout_tag != 0)
		gtk_timeout_remove(waitfor_timeout_tag);
	    waitfor_timeout_tag = 0;
	    if (current_script_item->next == NULL) {
		destroy_script();
	    } else {
		current_script_item = current_script_item->next;
		install_next_script();
	    }
	}
    }
    return size;
}

int waitformult_filter(char *buf, int size)
{
    return size;
}

void waitformulti(void)
{
}

void
set_pstring(char *str)
{
    g_free(p_string);
    p_string = g_strdup(str);
}

void transmit(char *str)
{
    term->from_term(str, strlen(str));
}

void script_goto(char *str)
{
    GList *list;
    Script *script;
    list = current_script_item;
    while (list) {
	script = list->data;
	if (script->type == LABEL) {
	    if (strcmp(script->arg[0], str) == 0) {
		current_script_item = list;
		return;
	    }
	}
	list = list->prev;
    }
    list = current_script_item->next;
    while (list) {
	script = list->data;
	if (script->type == LABEL) {
	    if (strcmp(script->arg[0], str) == 0) {
		current_script_item = list;
		return;
	    }
	}
	list = list->next;
    }
    g_warning("invalid goto: %s", str);
}

void script_sleep(int msec)
{
    sleep_tag = gtk_timeout_add(msec, 
    				(GtkFunction)next_script, NULL);
    current_script_item = current_script_item->next;
}

static int run_fd[2];
static int run_input_tag;


static void
script_run_command_end(void)
{
    if(current_script_item->next) {
	current_script_item = current_script_item->next;
	install_next_script();
    } else {
	end_script();
    }
    gdk_input_remove(run_input_tag);
    close(run_fd[0]);
    read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				   input_handler, NULL);
}

static void 
run_input_handler(gpointer data, int source, GdkInputCondition con)
{
    char buf[256];
    int size = read(source, buf, 255);
    term->to_term(term, buf, size);
}

void
script_run_command(char *command)
{
    pid_t pid;
    pipe(run_fd);
    pid = fork();
    if (pid > 0) {
	/* parent */
	child_signal_add(pid, script_run_command_end);
	gdk_input_remove(read_input_tag);
	close(run_fd[1]);
	run_input_tag =
	    gdk_input_add(run_fd[0], GDK_INPUT_READ,
			  run_input_handler, NULL);
	return;
    }
    /* child part */
    dup2(read_fd, 0);
    dup2(read_fd, 1);
    close(read_fd);
    close(run_fd[0]);
    dup2(run_fd[1], 2);
    execlp("sh", "sh", "-c", command, NULL);
    g_warning("%s : fail to run '%s'", __FUNCTION__, command);
    _exit(1);
}


void run_login_script(void)
{
    char *script_file;
    if (!use_modem) {
	run_telnet_login_script();
	return;
    }
    if (pi.name == NULL || pi.script == NULL)
	return;
    script_file = g_strconcat (expand_path(script_path), "/", pi.script, NULL);
    run_script_from_file(script_file);
    g_free (script_file);
}


/* buf:  Ʈ
   des:  tokenϳ, ޸𸮰 ̹ ҴǾ־Ѵ.
   return:  token ó Ʈ  */

static char *
get_next_token(guchar *buf, guchar *d)
{
    guchar *s = buf;
    while (isspace(*s))
	s++;
    if (*s == '"') {
	*d++ = *s++;
	while (*s != '"' && *s)
	    *d++ = *s++;
	*d++ = *s++;
    } else {
	while (!isspace(*s) && *s)
	    *d++ = *s++;
    }
    *d = 0;
    return s;
}

Script *
get_string_arg(char *s)
{
    char tmp[256];
    char tmp2[256];
    Script *script;
    get_next_token(s, tmp);
    mextract_string (tmp, tmp2);
    script = g_new (Script, 1);
    script->arg = g_new (gpointer, 1);
    script->arg[0] = g_strdup (tmp2);
    return script;
}

static int mextract_string(char *src, char *des)
{
    if (*src++ != '"')
	return FALSE;
    while (*src != '"') {
	if (*src == '\\') {
	    src++;
	    switch (*src) {
	    case 'r':
		*des++ = '\r';
		break;
	    case 'n':
		*des++ = '\n';
		break;
	    default:
		*des++ = *src;
		break;
	    }
	    src++;
	} else if (*src == '^') {
	    src++;
	    *des++ = *src++ + '\b' - 'H';
	} else {
	    *des++ = *src++;
	}
    }
    *des = 0;
    return TRUE;
}

static Script *
parse_line(guchar *buf)
{
    Script *script = NULL;
    guchar *s;
    guchar token[256], tmp2[256];

    s = get_next_token(buf, token);
    if (strcmp(token, "waitfor") == 0) {
	get_next_token(s, token);
	mextract_string(token, tmp2);
	script = g_new(Script, 1);
	script->type = WAITFOR;
	script->arg = g_new(gpointer, 2);
	script->arg[0] = g_strdup(tmp2);
	script->arg[1] = 0;
    } else if (strcmp("transmit", token) == 0) {
	script = get_string_arg (s);
	script->type = TRANSMIT;
    } else if (strcmp("set-title", token) == 0) {
	script = get_string_arg (s);
	script->type = SETTITLE;
    } else if (strcmp("set-pstring", token) == 0) {
	script = get_string_arg (s);
	script->type = SETPSTRING;
    } else if (strcmp ("set-idle-time", token) == 0) {
	script = get_string_arg (s);
	script->type = SETIDLETIME;
    } else if (strcmp("bottom-menu", token) == 0) {
	script = get_string_arg (s);
	script->type = BOTTOMMENU;
    } else if (strcmp("play", token) == 0) {
	script = get_string_arg (s);
	script->type = PLAY;
    } else if (strcmp("run", token) == 0) {
	script = get_string_arg (s);
	script->type = RUN;
    } else if (strcmp("beep", token) == 0) {
	script = g_new(Script, 1);
	script->type = BEEP;
    } else if (strcmp("capture", token) == 0) {
	s = get_next_token(s, token);
	if (strcmp(token, "on") == 0) {
	    script = get_string_arg (s);
	    script->type = CAPTURE_ON;
	} else if (strcmp(token, "off") == 0) {
	    script = g_new(Script, 1);
	    script->type = CAPTURE_OFF;
	}
    } else if (strcmp("end", token) == 0) {
	return NULL;
    } else if (strcmp("disconnect", token) == 0) {
	script = g_new(Script, 1);
	script->type = DISCONNECT;
    } else if (strcmp("baudrate", token) == 0) {
	get_next_token(s, token);
	script = g_new(Script, 1);
	script->type = BAUDRATE;
	script->arg = g_new(gpointer, 1);
	script->arg[0] = g_strdup(token);
    } else if (strcmp("sleep", token) == 0) {
	get_next_token(s, token);
	script = g_new(Script, 1);
	script->type = SLEEP;
	script->arg = g_new(gpointer, 1);
	script->arg[0] = GINT_TO_POINTER(((int) (1000.0 * atof(token))));
    } else if (strcmp("goto", token) == 0) {
	script = get_string_arg (s);
	script->type = GOTO;
    } else if (strcmp("include", token) == 0) {
	script = get_string_arg (s);
	script->type = INCLUDE;
    } else {
	s = token;
	while (*s && !isspace(*s))
	    s++;
	s--;
	if (*s == ':') {
	    *s = 0;
	    script = g_new(Script, 1);
	    script->type = LABEL;
	    script->arg = g_new(gpointer, 1);
	    script->arg[0] = g_strdup(token);
	} else
	    g_warning("unknown script '%s'", token);
    }
    return script;
}

static GList *
make_script_from_file(char *filename)
{
    FILE *fp;
    Script *script;
    GList *list;
    char *buf;
    if (filename == NULL || filename[0] == 0) {
	g_warning("filename is empty in %s", __FUNCTION__);
	return NULL;
    }
    fp = fopen(filename, "r");
    if (fp == NULL) {
	g_warning("fail to open %s", filename);
	return NULL;
    }
    list = NULL;
    while ((buf = get_line(fp)) != NULL) {
	script = parse_line(buf);
	if (script == NULL)
	    break;

	if (script->type == INCLUDE) {
	    list = include_script(list, script);
	} else
	    list = g_list_append(list, script);
    }
    fclose(fp);
    return list;
}

static GList *
make_script_from_string(char *str)
{
    GList *list;
    Script *script;
    char *s;
    char *buf = g_strdup(str);

    list = NULL;

    s = strtok(buf, ";");
    while (s != NULL) {
	script = parse_line(s);
	if (script == NULL)
	    break;
	if (script->type == INCLUDE) {
	    list = include_script(list, script);
	} else
	    list = g_list_append(list, script);
	s = strtok(NULL, ";");
    }
    g_free(buf);
    return list;
}

static GList *
make_script_from_command(char *command)
{
    FILE *fp;
    GList *list;
    Script *script;
    char *buf;
    void (*chld_handler) (int);
    chld_handler = signal(SIGCHLD, SIG_DFL);
    fp = popen(command, "rw");
    if (fp == NULL) {
	g_warning("fail to run %s", command);
	return NULL;
    }
    list = NULL;
    while ((buf = get_line(fp)) != NULL) {
	script = parse_line(buf);
	if (script == NULL)
	    break;
	if (script->type == INCLUDE) {
	    list = include_script(list, script);
	} else
	    list = g_list_append(list, script);
    }
    pclose(fp);
    signal(SIGCHLD, chld_handler);
    return list;
}

static GList *
include_script(GList * list, Script * script)
{
    GList *sublist, *last;
    char *script_file;
    script_file = g_strconcat (expand_path(script_path), 
    			       "/", 
			       script->arg[0], NULL);
    sublist = make_script_from_file(script_file);
    g_free (script_file);
    if (sublist != NULL) {
	if (list == NULL)
	    list = sublist;
	else {
	    last = g_list_last(list);
	    last->next = sublist;
	    sublist->prev = last;
	}
    }
    g_free(script->arg[0]);
    g_free(script->arg);
    g_free(script);
    return list;
}

void destroy_script(void)
{
    Script *script;
    GList *first, *list;
    first = g_list_first(current_script_item);
    list = first;

    while (list) {
	script = list->data;
	switch (script->type) {
	case WAITFOR:
	case BOTTOMMENU:
	case SETTITLE:
	case SETPSTRING:
	case SETIDLETIME:
	case CAPTURE_ON:
	case PLAY:
	case LABEL:
	case GOTO:
	case TRANSMIT:
	case BAUDRATE:
	case RUN:
	    g_free(script->arg[0]);
	    g_free(script->arg);
	    break;
	case WAITFOR_MULTI:
	case SLEEP:
	    g_free(script->arg);
	    break;
	default:
	    break;
	}
	g_free(script);
	list = list->next;
    }
    g_list_free(first);
}


void script_cancel(void)
{
    if (waitfor_waiting) {
	if (waitfor_timeout_tag > 0)
	    gtk_timeout_remove(waitfor_timeout_tag);
	input_filter_list = g_list_remove(input_filter_list,
					  waitfor_filter);
	waitfor_waiting = FALSE;
    }
    if (idle_tag != 0)
	gtk_timeout_remove(idle_tag);
    if (sleep_tag != 0)
	gtk_timeout_remove(sleep_tag);
    destroy_script();
    if (script_capture_active)
	end_capture();
    current_script_item = NULL;
}


int 
next_script(void)
{
    Script *script;
    int type = -1;
    idle_tag = 0;
    sleep_tag = 0;
    if (current_script_item == NULL) {
	g_warning("script is null");
	return FALSE;
    }
    script = current_script_item->data;
    switch (type = script->type) {
    case WAITFOR:
	waitfor(script->arg[0], GPOINTER_TO_INT(script->arg[1]));
	break;
    case TRANSMIT:
	transmit(script->arg[0]);
	break;
    case SETTITLE:
	gau_set_title(script->arg[0]);
	break;
    case SETPSTRING:
	set_pstring(script->arg[0]);
	break;
    case BAUDRATE:
	modem_setbaud(read_fd, script->arg[0]);
	break;
    case SETIDLETIME:
	{
	    int ti = atoi (script->arg[0]);
	    if (ti > 0) 
		idle_guard_interval = ti;
	}
	break;
    case BOTTOMMENU:
	script_bottom_menu_update(script->arg[0]);
	break;
    case BEEP:
	gdk_beep();
	break;
    case PLAY:
	play(script->arg[0]);
	break;
    case DISCONNECT:
	gau_hangup();
	break;
    case CAPTURE_ON:
	script_capture_active = TRUE;
	begin_capture(script->arg[0]);
	break;
    case CAPTURE_OFF:
	script_capture_active = FALSE;
	end_capture();
	break;
    case SLEEP:
	script_sleep(GPOINTER_TO_INT(script->arg[0]));
	break;
    case RUN:
	script_run_command(script->arg[0]);
	return FALSE;
	break;
    case GOTO:
	script_goto(script->arg[0]);
	break;
    case LABEL:
	break;
    default:
	g_print("%p script_list\n", current_script_item);
	g_warning("unknown type %d: in next-script", type);
	show_message ("ȥڸ ");
	gau_state = GAU_NOTHING;
	current_script_item = NULL;
	return FALSE;
    }
    if (current_script_item->next == NULL && script->type != WAITFOR && script->type != WAITFOR_MULTI && script->type != SLEEP) {
	end_script();
	return FALSE;
    }
    if (script->type != WAITFOR &&
	script->type != WAITFOR_MULTI &&
	script->type != SLEEP &&
	current_script_item->next) {
	current_script_item = current_script_item->next;
	script = current_script_item->data;
	if (script->type == WAITFOR || script->type == WAITFOR_MULTI) {
	    waitfor(script->arg[0], GPOINTER_TO_INT(script->arg[1]));
	} else
	    install_next_script();
    }
    return FALSE;
}

static void end_script(void)
{
    destroy_script();
    current_script_item = NULL;
    show_message("ȥڸ ϴ");
    gau_state = GAU_NOTHING;
}

int delayed_timeout(char *buf)
{
    term->from_term(buf, strlen(buf));
    g_free(buf);
    return FALSE;
}

void delayed_transmit(char *s, int bytes, int msec)
{
    char *buf = g_new(char, bytes + 1);
    int i;
    for (i = 0; i < bytes; i++)
	buf[i] = s[i];
    buf[i] = 0;
    gtk_timeout_add(msec, (GtkFunction) delayed_timeout, buf);
}

void prepare_telnet_script(char *script_file)
{
    telnet_script = NULL;
    if (script_file == NULL || script_file[0] == 0)
	return;
    script_file = g_strconcat(expand_path(script_path), "/", script_file, NULL);
    telnet_script = make_script_from_file(script_file);
    g_free (script_file);
}

static void run_telnet_login_script(void)
{
    if (telnetinfo && telnet_script) {
	current_script_item = telnet_script;
	install_next_script();
    }
}

void run_script_from_file(char *filename)
{
    GList *list;
    list = make_script_from_file(filename);
    if (list == NULL) {
	g_warning("fail to run %s", filename);
	return;
    }
    if (current_script_item)
	script_cancel();
    current_script_item = list;
    install_next_script();
}

void run_script_from_string(char *str)
{
    GList *list;
    list = make_script_from_string(str);
    if (list == NULL) {
	g_warning("fail to run %s ...", str);
	return;
    }
    if (current_script_item)
	script_cancel();
    current_script_item = list;
    install_next_script();
}

void run_script_from_command(char *command)
{
    GList *list;
    list = make_script_from_command(command);
    if (list == NULL) {
	g_warning("fail to extract from command %s", command);
	return;
    }
    if (current_script_item)
	script_cancel();
    current_script_item = list;
    install_next_script();
}

void script_bottom_menu_update(char *menu_file)
{
    update_bottom_menu_from_file(menu_file);
}
