#include "scrolledchat.h"
#include "scw.h"
#include <gtk/gtksignal.h>

static void
line_changed_callback(GauChat *chat, GtkAdjustment *adjustment);

GauScrolledChat *
gau_scrolled_chat_new(GdkFont *font, int font_height, int font_ascent, int col, int row, int visible_row,
	gpointer func)
{
	GauScrolledChat *scrolled_chat = g_new(GauScrolledChat, 1);
	GauChat *chat;
	GtkAdjustment *vad;
	scrolled_chat->win = scw_new(); //gtk_scrolled_window_new(NULL, NULL);
	vad= gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow *)scrolled_chat->win);
	/*
	vad->value = 0;
	vad->upper = row;
	vad->step_increment = 1;
	vad->page_increment = visible_row;
	vad->page_size = visible_row;
	gtk_signal_emit_by_name(GTK_OBJECT(vad), "changed");
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_chat->win),
		GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	*/
		
	chat = GAU_CHAT(gau_chat_new(font, font_height, font_ascent, col, row, visible_row));
	scrolled_chat->chat = chat;
	/*
	gtk_widget_set_usize(scrolled_chat->win, -2,
		visible_row*chat->font_height);
		*/
	//gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_chat->win), GTK_WIDGET(chat));
	gtk_container_add (GTK_CONTAINER(scrolled_chat->win), GTK_WIDGET(chat));
	gtk_widget_show(GTK_WIDGET(chat));

	gtk_signal_connect(GTK_OBJECT(chat), "line_changed",
		GTK_SIGNAL_FUNC(line_changed_callback), vad);
	gtk_signal_connect(GTK_OBJECT(chat), "send",
		GTK_SIGNAL_FUNC(func), NULL);

	return scrolled_chat;
}

static void
line_changed_callback(GauChat *chat, GtkAdjustment *ad)
{
	int bl = ((int)ad->value);
	int el = ((int)(ad->value + ad->page_size));
	//g_print("%s:%d %d %d\n", __FUNCTION__,bl, el, chat->current_y);
	if(chat->current_y < bl) {
		ad->value = chat->current_y;
	} else if(chat->current_y >= el) {
		ad->value = (chat->current_y + 1)  - ad->page_size;
	} else {
		return;
	}
	gtk_signal_emit_by_name(GTK_OBJECT(ad), "value_changed");
}


