
/* this file is a part of gau software, (C) Hwang chi-deok 1997-1999        */

#include <gtk/gtk.h>
#include <ctype.h>
#include "ansiterm.h"

#include "gau.h"

#define SELECTION_STRIP_TRAILING_SPACE

static char tmpbuf[256];

#define LINE_BUFFER(y)   (term->buf + term->col*linenumber((y)))
#define RIGHT_DOWN 0
#define LEFT_UP 1
#define NOTHING 2
#define SAME_LINE  (selection_end_y == selection_begin_y)

static gboolean have_selection = FALSE;
static gboolean selection_visible = FALSE;
static gboolean selection_own = FALSE;
static gboolean mouse3_moved = FALSE;
static char *selection_buf;
static int selection_size;
static int selection_begin_x, selection_begin_y;
static int selection_end_x, selection_end_y;
static void select_start(AnsiTerm * w, int x, int y);
static void select_end(AnsiTerm * w, GdkEventButton *);
static void select_motion(AnsiTerm * w, int x, int y);
static void unselect(AnsiTerm *);
static int direction(int newx, int newy, int oldx, int oldy);
static void select_toggle(AnsiTerm *, int y, int x1, int x2);
static void select_clear(AnsiTerm *, int y, int x1, int x2);
static void check_selection_buf_size(AnsiTerm *, int more);
static void select_word(AnsiTerm * w, GdkEventButton * ev);
static void select_line(AnsiTerm * w, GdkEventButton * ev);
static int do_i_select;
static int do_select;
static gint popup_menu_cb(gpointer foo);

static GdkEventButton select_click;

static guint popup_tag = 0;
static GtkItemFactory *popup_menu = NULL;

int 
term_button_press_callback(GtkWidget * w, GdkEventButton * ev)
{
    AnsiTerm *term;

    term = ANSI_TERM(w);

    if (!GTK_WIDGET_HAS_FOCUS(w))
	gtk_widget_grab_focus(w);
    do_i_select = do_select = FALSE;
    if (ev->button == 3) {
	if (ev->type == GDK_2BUTTON_PRESS) {
	    select_word(term, ev);
	    return TRUE;
	} else if (ev->type == GDK_3BUTTON_PRESS) {
	    select_line(term, ev);
	    return TRUE;
	}
	gtk_grab_add(w);
	//select_start(term, ev->x, ev->y);
	select_click = *ev;
	do_select = TRUE;
	mouse3_moved = FALSE;
	popup_tag = gtk_timeout_add (500, popup_menu_cb, NULL);
    } else if (ev->button == 2 && ev->type == GDK_BUTTON_PRESS) {
	gtk_selection_convert(w, GDK_SELECTION_PRIMARY, GDK_TARGET_STRING,
			      ev->time);
    } else if (ev->button == 1) {
	if (ev->type == GDK_2BUTTON_PRESS || ev->type == GDK_3BUTTON_PRESS) {
	    return TRUE;
	}
	gtk_grab_add(w);
	if (term->mode & EDITOR_BUTTON) {
	    unsigned char x = ev->x / term->font_width + ' ' + 1;
	    unsigned char y = ev->y / term->font_height + ' ' + 1;
	    g_snprintf(tmpbuf, sizeof(tmpbuf), "\033[M%c%c%c", ' ', x, y);
	    term->from_term(tmpbuf, strlen(tmpbuf));
	    return TRUE;
	}
	do_i_select = TRUE;
	i_select_begin(term, ev->x, ev->y);
    }
    return TRUE;
}

int 
term_button_release_callback(GtkWidget * w, GdkEventButton * ev)
{
    AnsiTerm *term;

    term = ANSI_TERM(w);

    if (ev->button == 3) {
	gtk_grab_remove(w);
	if (mouse3_moved) {
	    select_end(term, ev);
	} else {
	    // popup 
	    if (p_string) {
		static guint32 last_send_time = 0;
		guint32 current_time = gdk_time_get();
		if (current_time > last_send_time + 500)
		    term->from_term(p_string, strlen(p_string));
		last_send_time = current_time;
	    }
	}
	if (popup_tag > 0) 
	    gtk_timeout_remove (popup_tag);
    } else if (ev->button == 1) {
	gtk_grab_remove(w);
	if (term->mode & EDITOR_BUTTON) {
	    unsigned char x = ev->x / term->font_width + ' ' + 1;
	    unsigned char y = ev->y / term->font_height + ' ' + 1;
	    g_snprintf(tmpbuf, sizeof(tmpbuf), "\033[M%c%c%c", ' ' + 3, x, y);
	    term->from_term(tmpbuf, strlen(tmpbuf));
	    return TRUE;
	}
	i_select_end(term, ev->x, ev->y);
    }
    return TRUE;
}

int 
term_motion_callback(AnsiTerm * term, GdkEventMotion * ev)
{
    if (popup_tag)
        gtk_timeout_remove (popup_tag);

    if (do_i_select) {
	i_select_motion(term, ev->x, ev->y);
    } else if (do_select) {
	if (!mouse3_moved) {
	    select_start(term, select_click.x, select_click.y);
	    mouse3_moved = TRUE;
	}
	select_motion(term, ev->x, ev->y);
    }
    return TRUE;
}

static gint
strip_trailing_space (guchar *des, guchar *src, int len)
{
    int end =  0;
    int i, j;
    j = len;
    for (i = len - 1; i >= 0; i--) {
	if (end) {
	    if (src[i] == ' ') continue; /* skip */
	    if (src[i] == '\n') { 
	        des[--j]= src[i];
		continue;
	    }
	    des[--j] = src[i];
	    end = 0;
	} else {
	    des[--j] = src[i];
	    if (src[i] == '\n') end = 1;
	}
    }
    return j;
}

void ansi_term_selection_handler(GtkWidget * widget, 
				 GtkSelectionData * selection_data, 
				 guint info,
				 guint time)
{
#ifdef SELECTION_STRIP_TRAILING_SPACE
    int offset;
    guchar *buf = g_new(guchar, selection_size);
    offset = strip_trailing_space (buf, selection_buf, selection_size);
    gtk_selection_data_set(selection_data, GDK_SELECTION_TYPE_STRING, 
			   8 * sizeof(gchar), buf + offset, 
			   selection_size - offset);
    g_free (buf);
#else /* !SELECTION_STRIP_TRAILING_SPACE */
    gtk_selection_data_set(selection_data, GDK_SELECTION_TYPE_STRING, 
    			   8 * sizeof(gchar), (guchar *) selection_buf, 
			   selection_size);
#endif /* !SELECTION_STRIP_TRAILING_SPACE */
}

int ansi_term_selection_clear(GtkWidget * widget, GdkEventSelection * event)
{
    //g_print("%s\n", __FUNCTION__);
    if (selection_visible)
	unselect(ANSI_TERM(widget));
    selection_size = 0;
    have_selection = FALSE;
    selection_own = FALSE;
    return FALSE;
}

void select_start(AnsiTerm * term, int x, int y)
{
    ansi_term_hide_cursor(term);
    if (have_selection) {
	unselect(term);
    }
    x = x / term->font_width;
    selection_begin_y = y = y / term->font_height;
    if (is_second_han(term->buf + term->col * linenumber(y), x)) {
	selection_begin_x = x - 1;
    } else
	selection_begin_x = x;
    selection_end_x = selection_begin_x;
    selection_end_y = selection_begin_y;
}

void select_end(AnsiTerm * term, GdkEventButton * ev)
{
    guchar *buf, *term_buf;
    int i, j;

    have_selection = TRUE;
    switch (direction(selection_end_x, selection_end_y,
		      selection_begin_x, selection_begin_y)) {
    case LEFT_UP:
	term_buf = term->buf + term->col * linenumber(selection_end_y) +
	    selection_end_x;
	if (SAME_LINE) {
	    i = selection_begin_x - selection_end_x;
	    check_selection_buf_size(term, i);
	    memcpy(selection_buf, term_buf, i);
	    selection_size = i;
	} else {
	    i = term->col - selection_end_x;
	    check_selection_buf_size(term, i + 1);
	    memcpy(selection_buf, term_buf, i);
	    buf = selection_buf + i;
	    *buf++ = '\n';
	    term_buf += i;
	    selection_size = i + 1;
	    for (j = selection_end_y + 1; j < selection_begin_y; j++) {
		check_selection_buf_size(term, term->col + 1);
		buf = selection_buf + selection_size;
		memcpy(buf, term_buf, term->col);
		buf += term->col;
		term_buf += term->col;
		if (term_buf > (term->buf + term->col * term->saved_lines))
		    term_buf = term->buf;
		*buf++ = '\n';
		selection_size += term->col + 1;
	    }
	    i = selection_begin_x;
	    check_selection_buf_size(term, i);
	    buf = selection_buf + selection_size;
	    memcpy(buf, term_buf, i);
	    selection_size += i;
	}
	have_selection = TRUE;
	break;
    case RIGHT_DOWN:
	term_buf = term->buf + linenumber(selection_begin_y) * term->col +
	    selection_begin_x;
	if (SAME_LINE) {
	    i = selection_end_x - selection_begin_x;
	    check_selection_buf_size(term, i);
	    selection_size = i;
	    memcpy(selection_buf, term_buf, selection_size);
	} else {
	    i = term->col - selection_begin_x;
	    check_selection_buf_size(term, term->col * (selection_end_y - selection_begin_y));
	    memcpy(selection_buf, term_buf, i);
	    buf = selection_buf + i;
	    *buf++ = '\n';
	    term_buf += i;
	    selection_size = i + 1;
	    for (j = selection_begin_y + 1; j < selection_end_y; j++) {
		check_selection_buf_size(term, term->col);
		buf = selection_buf + selection_size;
		memcpy(buf, term_buf, term->col);
		buf += term->col;
		term_buf += term->col;
		if (term_buf - term->buf > term->col * term->saved_lines)
		    term_buf = term->buf;
		*buf++ = '\n';
		selection_size += term->col + 1;
	    }
	    i = selection_end_x;
	    check_selection_buf_size(term, i);
	    memcpy(selection_buf + selection_size, term_buf, i);
	    selection_size += i;
	}
	break;
    default:
	have_selection = FALSE;
	if (selection_own) {
	    gtk_selection_owner_set(NULL, GDK_SELECTION_PRIMARY,
				    GDK_CURRENT_TIME);
	    selection_own = FALSE;
	    //g_print("selection lost\n");
	}
	break;
    }
    ansi_term_show_cursor(term);
    if (have_selection) {
	if (!selection_own) {
	    int i;
	    selection_own = TRUE;
	    //g_print("selection gain\n");
	    i = gtk_selection_owner_set(GTK_WIDGET(term), GDK_SELECTION_PRIMARY,
					GDK_CURRENT_TIME);
	    //g_print("%d\n", i);

	} else {
	    gtk_selection_owner_set(GTK_WIDGET(term), GDK_SELECTION_PRIMARY,
				    GDK_CURRENT_TIME);
	    //g_print("selection owner already\n");
	}
	selection_visible = TRUE;
    }
}


void select_motion(AnsiTerm * term, int x, int y)
{
    char *attr;
    int j;
    x = x / term->font_width;
    y = y / term->font_height;
    if (x < 0)
	x = 0;
    else if (x >= term->col)
	x = term->col;
    if (y < 0)
	y = 0;
    else if (y >= term->row)
	y = term->row - 1;
    switch (direction(x, y, selection_end_x, selection_end_y)) {
    case RIGHT_DOWN:
	if (is_second_han(term->buf + term->col * linenumber(y), x)) {
	    x++;
	}
	attr = term->attr + term->col * linenumber(y) + selection_end_x;
	if (y == selection_end_y) {
	    if (x != selection_end_x)
		select_toggle(term, y, selection_end_x, x - 1);
	} else {
	    select_toggle(term, selection_end_y, selection_end_x, term->col - 1);
	    for (j = selection_end_y + 1; j < y; j++) {
		select_toggle(term, j, 0, term->col - 1);
	    }
	    select_toggle(term, j, 0, x - 1);
	}
	break;
    case LEFT_UP:
	if (is_second_han(LINE_BUFFER(y), x))
	    x--;
	attr = term->attr + term->col * linenumber(y) + selection_end_x;
	if (y == selection_end_y) {
	    select_toggle(term, y, x, selection_end_x - 1);
	} else {
	    select_toggle(term, selection_end_y, 0, selection_end_x - 1);
	    for (j = selection_end_y - 1; j > y; j--) {
		select_toggle(term, j, 0, term->col - 1);
	    }
	    select_toggle(term, j, x, term->col - 1);
	}
	break;
    default:
	break;
    }
    selection_end_x = x;
    selection_end_y = y;
}

#define SWAP(a,b) { tmp = a;a=b;b=tmp;}
int tmp;
void unselect(AnsiTerm * term)
{
    int y;
    if (direction(selection_end_x, selection_end_y,
		  selection_begin_x, selection_begin_y) != RIGHT_DOWN) {
	SWAP(selection_begin_x, selection_end_x);
	SWAP(selection_begin_y, selection_end_y);
    }
    if (selection_begin_y == selection_end_y) {
	select_clear(term, selection_begin_y, selection_begin_x,
		     selection_end_x - 1);
    } else {
	select_clear(term, selection_begin_y,
		     selection_begin_x, term->col - 1);
	for (y = selection_begin_y + 1; y < selection_end_y; y++)
	    select_clear(term, y, 0, term->col - 1);
	select_clear(term, y, 0, selection_end_x - 1);
    }
    selection_visible = FALSE;
}

void select_toggle(AnsiTerm * term, int y, int x1, int x2)
{
    int i;
    char *attr = term->attr + linenumber(y) * term->col + x1;
    for (i = x1; i <= x2; i++)
	*attr++ ^= ATTR_SELECTION;
    ansi_term_expose_line(term, y, x1, x2);
}

void select_clear(AnsiTerm * term, int y, int x1, int x2)
{
    int i;
    char *attr = term->attr + linenumber(y) * term->col + x1;
    for (i = x1; i <= x2; i++)
	*attr++ &= ~ATTR_SELECTION;
    ansi_term_expose_line(term, y, x1, x2);
}

int direction(int newx, int newy, int oldx, int oldy)
{
    if (oldy > newy)
	return LEFT_UP;
    if (oldy < newy)
	return RIGHT_DOWN;
    if (oldx > newx)
	return LEFT_UP;
    if (oldx < newx)
	return RIGHT_DOWN;
    return NOTHING;
}

void check_selection_buf_size(AnsiTerm * term, int more)
{
    static int buf_size = 0;
    if (selection_size + more > buf_size) {
	buf_size = selection_size + more + 2;
	selection_buf = g_realloc(selection_buf, buf_size);
    }
}

void select_word(AnsiTerm * term, GdkEventButton * ev)
{
    guchar *buf;
    int x, y;

    if (have_selection)
	unselect(term);
    x = ev->x / term->font_width;
    y = ev->y / term->font_height;
    buf = term->buf + term->col * linenumber(y) + x;
    if (*buf != '_' && (!isalnum(*buf)) && ((*buf & 0x80) == 0)) {
	for (; x >= 0; x--) {
	    if (*buf == '_' || isalnum(*buf) || (*buf & 0x80))
		break;
	    buf--;
	}
    }
    for (; x >= 0; x--) {
	if (*buf != '_' && !isalnum(*buf) && ((*buf & 0x80) == 0))
	    break;
	buf--;
    }
    x++;
    buf++;
    selection_begin_x = selection_end_x = x;
    selection_begin_y = selection_end_y = y;
    for (; x < term->col; x++) {
	if (*buf != '_' && !isalnum(*buf) && ((*buf & 0x80) == 0))
	    break;
	buf++;
    }
    select_motion(term, x * term->font_width, y * term->font_height);
    select_end(term, ev);
}

void select_line(AnsiTerm * term, GdkEventButton * ev)
{
    if (have_selection)
	unselect(term);
    selection_begin_x = selection_end_x = 0;
    selection_begin_y = selection_end_y = ev->y / term->font_height;
    select_motion(term, term->col * term->font_width, ev->y);
    select_end(term, ev);
}

void check_in_selection(AnsiTerm * term)
{
    if (selection_visible 
        && *(term->attr + linenumber(term->cu_y) * term->col 
	     + term->cu_x) & ATTR_SELECTION) {
	unselect(term);
    }
}

void
popup_menu_delete_cb(GtkWidget *w, gpointer data)
{
    int row, col;

    row = select_click.y / term->font_height;
    col = select_click.x / term->font_width;
}

void
popup_menu_add_cb(GtkWidget *w, gpointer data)
{
    int row, col;

    row = select_click.y / term->font_height;
    col = select_click.x / term->font_width;

}

gint
popup_menu_cb(gpointer data)
{
    static GtkItemFactoryEntry menuentry[] = {
	{"/Delete", NULL, popup_menu_delete_cb, 0, "<Item>"},
	{"/Play", NULL, popup_menu_add_cb, 0, "<Item>"}
    };
    int nmenu;
    gtk_grab_remove ( GTK_WIDGET(term));

    if (popup_menu) {
	gtk_menu_popup( GTK_MENU(popup_menu->widget), NULL, NULL, 
			NULL, NULL, 0,0);
	return FALSE;
    }

    popup_menu = gtk_item_factory_new (GTK_TYPE_MENU, "<popup>", NULL);
    nmenu = sizeof (menuentry) / sizeof (menuentry[0]);
    gtk_item_factory_create_items (popup_menu, nmenu, menuentry, NULL);
    gtk_menu_popup( GTK_MENU(popup_menu->widget), NULL, NULL, NULL, NULL, 0,0);
    return FALSE;
}
