/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998         */

#include "config.h"

#include <signal.h>		/* kill */
#include <unistd.h>		/* read, ... */

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <string.h>


#include "gau.h"

gboolean disconnect_after_transfer = FALSE;
gboolean auto_rz = TRUE;
gboolean auto_sz = TRUE;

static GtkWidget *sz_filename_entry;
static GtkWidget *sz_query_win;
static void run_real_sz(char *filename);
static int srz_pid = -1;

int 
zmodem_input_filter(char *str, int bytes)
{
    static char zmSig[] = "**\030B0";
    static char *zmSigPtr = zmSig;
    int i;
    /* check signature of zmodem */
    for (i = 0; i < bytes; i++) {
	if (*zmSigPtr == '\0') {
	    if (str[i] == '0') {
		if (auto_rz) run_rz();
		zmSigPtr = zmSig;
		break;
	    } else if (str[i] == '1') {
		if (auto_sz) delayed_run(100, run_sz);
		zmSigPtr = zmSig;
		break;
	    }
	    zmSigPtr = zmSig;
	} else {
	    if (str[i] != *zmSigPtr)
		zmSigPtr = zmSig;
	    else
		zmSigPtr++;
	}
    }
    return bytes;
}

static void rz_signal_child_handle(void);
static void sz_signal_child_handle(void);

static int srz_input_tag;
static int srzpipefd[2];

static void 
srz_input_handler(gpointer data, int source, GdkInputCondition con)
{
    char buf[256];
    int size = read(source, buf, 255);
    term->to_term(term, buf, size);
}


void 
run_rz(void)
{
    gau_state = GAU_DOWNLOAD;
    gtk_widget_set_sensitive(disconnect_after_transfer_button, TRUE);
    pipe(srzpipefd);
    srz_pid = fork();
    if (srz_pid > 0) {
	/* parent */
	child_signal_add(srz_pid, rz_signal_child_handle);
	gdk_input_remove(read_input_tag);
	close(srzpipefd[1]);
	srz_input_tag =
	    gdk_input_add(srzpipefd[0], GDK_INPUT_READ,
			  srz_input_handler, NULL);
	return;
    }
    /* child part */
    chdir(expand_path(down_path));
    dup2(read_fd, 0);
    dup2(read_fd, 1);
    close(read_fd);
    close(srzpipefd[0]);
    dup2(srzpipefd[1], 2);
    execlp("sh", "sh", "-c", rz_command, NULL);
    g_warning("%s : fail to run '%s'", __FUNCTION__, rz_command);
    _exit(1);
}

static void 
sz_send(void)
{
    char *s = gtk_entry_get_text(GTK_ENTRY(sz_filename_entry));
    if (s == NULL || access(s, R_OK)) {
	gdk_beep();
	gdk_beep();
	g_warning("Filename(%s) to send is invalid", s);
	return;
    }
    run_real_sz(s);
    gtk_widget_destroy(sz_query_win);
}

static void 
sz_initial_cancel(GtkWidget * w, GtkWidget * win)
{
    static char canistr[] =
    {
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0
    };
    term->from_term(canistr, strlen(canistr));
    if (win)
	gtk_widget_destroy(win);
    gtk_widget_set_sensitive(disconnect_after_transfer_button, FALSE);
}

static void 
sz_file_selection_ok(GtkWidget * w, GtkWidget * win)
{
    char buf[256];
    char *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(win));
    if (getcwd(buf, 256) != NULL) {
	int n = strlen(buf);
	if (strncmp(filename, buf, n) == 0 && filename[n] == '/') {
	    gtk_entry_set_text(GTK_ENTRY(sz_filename_entry), filename + n + 1);
	} else {
	    gtk_entry_set_text(GTK_ENTRY(sz_filename_entry), filename);
	}
    } else {
	gtk_entry_set_text(GTK_ENTRY(sz_filename_entry), filename);
    }
    gtk_widget_destroy(win);
    gtk_grab_add(sz_query_win);
}

static void 
sz_file_selection_cancel(GtkWidget * w, GtkWidget * win)
{
    gtk_widget_destroy(win);
    gtk_grab_add(sz_query_win);
}

static void 
sz_file_search(GtkWidget * w, gpointer data)
{
    GtkWidget *file_selection = gtk_file_selection_new("  ãƺ");
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file_selection));
    gtk_window_set_position(GTK_WINDOW(file_selection), GTK_WIN_POS_MOUSE);
    gtk_signal_connect(
	       GTK_OBJECT(GTK_FILE_SELECTION(file_selection)->ok_button),
			  "clicked",
			  GTK_SIGNAL_FUNC(sz_file_selection_ok),
			  file_selection);
    gtk_signal_connect(
	   GTK_OBJECT(GTK_FILE_SELECTION(file_selection)->cancel_button),
			  "clicked",
			  GTK_SIGNAL_FUNC(sz_file_selection_cancel),
			  file_selection);
    gtk_grab_remove(sz_query_win);
    gtk_widget_show(file_selection);
}

void 
run_sz(void)
{
    GtkWidget *vbox, *button, *label, *hbox;
    // avoid the abundant popup of dialog
    if (GTK_WIDGET_IS_SENSITIVE(disconnect_after_transfer_button))
	return;
    gtk_widget_set_sensitive(disconnect_after_transfer_button, TRUE);
    sz_query_win = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_container_set_border_width(GTK_CONTAINER(sz_query_win), 10);
    gtk_window_set_title(GTK_WINDOW(sz_query_win), " ");
    gtk_window_set_position(GTK_WINDOW(sz_query_win), GTK_WIN_POS_MOUSE);
    vbox = gtk_vbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(sz_query_win), vbox);
    gtk_widget_show(vbox);

    hbox = gtk_hbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);
    gtk_widget_show(hbox);

    label = gtk_label_new(" ̸:");
    gtk_container_add(GTK_CONTAINER(hbox), label);
    gtk_widget_show(label);

    sz_filename_entry = gtk_entry_new();
    gtk_container_add(GTK_CONTAINER(hbox), sz_filename_entry);
    gtk_signal_connect(GTK_OBJECT(sz_filename_entry), "activate",
		       (GtkSignalFunc) sz_send, sz_query_win);
    gtk_widget_show(sz_filename_entry);
    gtk_widget_new(gtk_hseparator_get_type(),
		   "GtkWidget::parent", vbox,
		   "GtkWidget::visible", TRUE,
		   NULL);
    hbox = gtk_hbox_new(FALSE, 10);
    gtk_container_add(GTK_CONTAINER(vbox), hbox);
    gtk_widget_show(hbox);

    button = gtk_button_new_with_label("ãƺ");
    gtk_container_add(GTK_CONTAINER(hbox), button);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       (GtkSignalFunc) sz_file_search, sz_query_win);
    gtk_widget_show(button);

    button = gtk_button_new_with_label("");
    gtk_container_add(GTK_CONTAINER(hbox), button);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       (GtkSignalFunc) sz_initial_cancel, sz_query_win);
    gtk_widget_show(button);

    button = gtk_button_new_with_label("");
    gtk_container_add(GTK_CONTAINER(hbox), button);
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       (GtkSignalFunc) sz_send, sz_query_win);
    gtk_widget_show(button);

    gtk_widget_show(sz_query_win);
    gtk_widget_grab_focus(sz_filename_entry);
    // FIXME: grab  gtk+970925 ٲ.
    gtk_grab_add(sz_query_win);
}


static void 
run_real_sz(char *filename)
{
    GString *str;
    if (!use_modem && use_ztelnet) {
	/* 
	 * ztelnet  ztelnet ɾ  ȯϰ
	 * szɾ 
	 */
	str = g_string_new (NULL);
	g_string_append_c (str, ']' & 0x1f);
	term->from_term(str->str, str->len);
	usleep(20000);
	g_string_sprintf (str, "%s %s\r", sz_command, filename);
	term->from_term(str->str, str->len);
	g_string_free (str, TRUE);
	return;
    }
    pipe(srzpipefd);
    srz_pid = fork();
    if (srz_pid > 0) {
	/* parent */
	child_signal_add(srz_pid, sz_signal_child_handle);
	gdk_input_remove(read_input_tag);
	close(srzpipefd[1]);
	srz_input_tag = gdk_input_add(srzpipefd[0], 
				      GDK_INPUT_READ, 
				      srz_input_handler, 
				      NULL);
	gau_state = GAU_UPLOAD;
	return;
    }
    // child
    dup2 (read_fd, 0);
    dup2 (read_fd, 1);
    close (read_fd);
    dup2 (srzpipefd[1], 2);
    close (srzpipefd[0]);
    str = g_string_new (NULL);
    g_string_sprintf (str, "%s %s", sz_command, filename);
    execlp("sh", "sh", "-c", str->str, NULL);
    g_warning("%s : fail to run sz", __FUNCTION__);
    _exit(1);
}

static int 
confirm_death_of_rz(void)
{
    if (srz_pid > 0) {
	// still alive.
	// no pity
	kill(srz_pid, SIGKILL);
    }
    return FALSE;		// just once

}


void 
rz_cancel(void)
{
    static char canistr[] =
    {
	24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0
    };

    if (srz_pid <= 0)
	return;
    // first ask remote side to quit
    // ̹  sz  kill ؾ.
    term->from_term(canistr, strlen(canistr));
    gtk_timeout_add(1000, (GtkFunction) confirm_death_of_rz, NULL);
}

void 
sz_cancel(void)
{
    if (srz_pid <= 0)
	return;
    kill(srz_pid, SIGKILL);
}

static void 
rz_signal_child_handle(void)
{
    /*
       int status;
       if(!WIFEXITED(status) || (WIFEXITED(status) && WEXITSTATUS(status) != 0)) {
       // killed by a signal which was not caught;
       // or exit code is not zero;
       static char canistr[] = {
       24,24,24,24,24,24,24,24,24,24,8,8,8,8,8,8,8,8,8,8,0
       };
       g_print("rz exit abnormally\n");
       term->from_term(canistr, strlen(canistr));
       } 
     */
    if (disconnect_after_transfer) {
	gau_hangup();
    }
    gtk_widget_set_sensitive(disconnect_after_transfer_button, FALSE);
    play_transfer_end();
    srz_pid = -1;
    gdk_input_remove(srz_input_tag);
    close(srzpipefd[0]);
    read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				   input_handler, NULL);
}

static void 
sz_signal_child_handle(void)
{
    gdk_input_remove(srz_input_tag);
    read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				   input_handler, NULL);
    play_transfer_end();
    if (disconnect_after_transfer) {
	gau_hangup();
    } else
	gtk_widget_set_sensitive(disconnect_after_transfer_button, FALSE);
    srz_pid = -1;
}
