/** @file cfio_io.h
 * This file contains data definitions and prototypes 
 * that define one instance of compact flash interface
 *
 * Copyright (c) Marvell Semiconductor, Inc., 2003-2005
 */
/******************************************************
Change log:
	09/29/05: add Doxygen format comments
******************************************************/ 

#ifndef _CF_IO_IO_H_
#define _CF_IO_IO_H_

#define EXTERN extern

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ptrace.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/ioport.h>
#include <linux/module.h> 
#include <asm/io.h>
#include <asm/system.h>
#include <linux/net.h>
#include <asm/irq.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/if_arp.h>
#include <linux/ioport.h>
#include <linux/config.h>

#include <pcmcia/version.h>
#include <pcmcia/cs_types.h>
#include <pcmcia/cs.h>
#include <pcmcia/cistpl.h>
#include <pcmcia/cisreg.h>
#include <pcmcia/ds.h>
#include <pcmcia/bus_ops.h>

//      INT code register event definition
#define MACREG_INT_CODE_TX_PPA_FREE       0x00000000
#define MACREG_INT_CODE_TX_DMA_DONE       0x00000001
#define MACREG_INT_CODE_LINK_LOSE_W_SCAN  0x00000002
#define MACREG_INT_CODE_LINK_LOSE_NO_SCAN 0x00000003
#define MACREG_INT_CODE_LINK_SENSED       0x00000004
#define MACREG_INT_CODE_CMD_FINISHED      0x00000005
#define MACREG_INT_CODE_MIB_CHANGED       0x00000006
#define MACREG_INT_CODE_INIT_DONE         0x00000007
#define MACREG_INT_CODE_DEAUTHENTICATED   0x00000008
#define MACREG_INT_CODE_DISASSOCIATED     0x00000009
#define MACREG_INT_CODE_PS_AWAKE          0x0000000a
#define MACREG_INT_CODE_PS_SLEEP          0x0000000b

#define CF_Signature        0xDEADBEEF

/*CF card data structure*/
struct cf_card_rec
{
  struct net_device *eth_dev;
  unsigned long port;
  u16 irq;
  u16 host_int_mask;
  u8  flag;
  u8  reserved[3];
  int do_read_modify_write;
  void *(*add)(struct cf_card_rec *card);
  int   (*remove)(struct cf_card_rec *card);
  void  (*user_isr)(int, void*, struct pt_regs*);
} ;

typedef void *  (*cf_notifier_fn_add) (struct cf_card_rec *);
typedef int (*cf_notifier_fn_remove) (struct cf_card_rec *);

extern dev_info_t cfio_dev_info;
extern dev_link_t *dev_list;

extern struct cf_card_rec cardp;
s16 cfio_read_cfg_reg(void *priv);


#endif  /* _CF_IO_IO_H_ */
