package maslab.camera;

import maslab.util.*;
import maslab.orc.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.imageio.*;
import java.util.*;
import maslab.orcspy.*;

public class PadCam
{
    public static void main(String[] args)
    {
	Orc orc;
	Camera cam;
	Logger log=new Logger("PadCam");

	try {
	    orc=new Orc();
	} catch (IOException ex) {
	    log.error("Couldn't open Orc");
	    return;
	}

	try {
	    cam = new Camera();
	} catch (IOException ex) {
	    log.error("Couldn't open camera",ex);
	    return;
	}

	cam.setCaptureSettings(160,120,30);

	orc.lcdClear();

	while(orc.padButtonsPoll()==0)
	    {
		BufferedImage bi=cam.capture(null);

		double aspect=bi.getWidth()/((double) bi.getHeight());
		double width=128;
		double height=width/aspect;
		if (height>56) // scale the other way
		    {
			height=56;
			width=aspect*height;
		    }
		bi=scaleImage(bi,(int) width, (int) height);

		BufferedImage dith=ImageUtil.ditherImage(bi);
		
		orc.lcdWrite(0,8,dith);
	    }

	log.output("Quitting");
    }

    public static BufferedImage scaleImage(BufferedImage in, int width, int height)
    {
	BufferedImage out=new BufferedImage(width, height, in.getType());

	Graphics2D g=out.createGraphics();

	g.drawImage(in, 0, 0, width, height, null);

	return out;
    }

}
