package maslab.orc;

import maslab.util.*;

/** Orc wrapper for Digital inputs (using built-in pull-ups.) **/
public class DigitalInput
{
    Orc orc;
    int port;
    boolean inverted;

    /** Create a new DigitalInput. 
     * @param inverted If true, the digital value is inverted before it is returned.
     **/
    public DigitalInput(Orc orc, int port, boolean inverted)
    {
	this.orc=orc;
	this.port=port;
	this.inverted=inverted;

	orc.pinModeWrite(port, Orc.PinMode.DIGITAL_IN_PULLUP);
    }

    public boolean read()
    {
	boolean v=orc.digitalRead(port);
	
	return inverted ? !v : v;
    }
}
