package maslab.orc;

/** Interface for range sensors. **/
public interface RangeSensor
{
    /** Distance that the sensor currently is measuring, in meters. **/
    public double getRange();

    /** Variance of the sensor's current measurement. Compute square
     * root for standard deviation.
     **/
    public double getRangeUncertainty();

    /** The rough interior angle of the arc upon which an object might
     * lie, in radians. In general, can be a function of the sensor's
     * current measurement.
     **/
    public double getArcAngle();
}
