package maslab.orcspy;

import java.awt.*;
import java.awt.image.*;
import java.awt.geom.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class JImage extends JComponent
{
    public static final long serialVersionUID=1001;

    Image i;
    boolean scale=false;

    public JImage()
    {
	i=null;
    }

    public JImage(int width, int height)
    {
	i=new BufferedImage(width, height, BufferedImage.TYPE_BYTE_GRAY);
    }

    public void setImage(Image i)
    {
	this.i=i;
	invalidate();
	repaint();
    }

    public Dimension getMinimumSize()
    {
	if (i==null)
	    return new Dimension(2,2);

	return new Dimension(i.getWidth(null), i.getHeight(null));
    }

    public Dimension getPreferredSize()
    {
	return getMinimumSize();
    }

    public Dimension getMaximumSize()
    {
	return getMinimumSize();
    }

    public Point componentToImage(Point p)
    {
	int height=getHeight();
	int width=getWidth();
	int cy=height/2;
	int cx=width/2;
	int imheight=i.getHeight(null);
	int imwidth=i.getWidth(null);
	int imx, imy;

	if (scale)
	    {
		int imageratio=imwidth/imheight;
		int displayratio=width/height;

		int scalewidth,scaleheight;
		if (imageratio>=displayratio)
		    {
			scalewidth=width;
			scaleheight=width*imheight/imwidth;
		    }
		else
		    {
			scaleheight=height;
			scalewidth=height*imwidth/imheight;
		    }
		
		imx=imwidth*(p.x-cx)/scalewidth+imwidth/2;
		imy=imheight*(p.y-cy)/scaleheight+imheight/2;
	    }
	else
	    {
		imx=p.x-cx+imwidth/2;
		imy=p.y-cy+imheight/2;
	    }
	if (imx<0 || imy<0 || imx>=imwidth || imy>=imheight)
	    return null;

	return new Point(imx,imy);
    }

    public synchronized void paint(Graphics gin)
    {
	Graphics2D g=(Graphics2D) gin;

	int height=getHeight();
	int width=getWidth();
	int cy=height/2;
	int cx=width/2;

	int imheight=i.getHeight(null);
	int imwidth=i.getWidth(null);

	if (scale)
	    {
		int imageratio=imwidth/imheight;
		int displayratio=width/height;

		int scalewidth,scaleheight;
		if (imageratio>=displayratio)
		    {
			scalewidth=width;
			scaleheight=width*imheight/imwidth;
		    }
		else
		    {
			scaleheight=height;
			scalewidth=height*imwidth/imheight;
		    }
		
		g.drawImage(i, cx-scalewidth/2, cy-scaleheight/2, scalewidth, scaleheight, Color.black, null);
	    }
	else
	    g.drawImage(i, cx-imwidth/2, cy-imheight/2, null);
    }

    public void setScale(boolean b)
    {
	scale=b;
    }
}
