package maslab.orcspy;

import maslab.util.*;
import maslab.orc.*;

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;

public class PadPanel extends JPanel implements OrcUpdateListener
{
    public static final long serialVersionUID=1001;

    Orc orc;
    int port;

    JLabel stoplabel =  new JLabel("0");
    JLabel menulabel =  new JLabel("0");
    JLabel sticklabel =  new JLabel("0");

    JoystickCircle jc=new JoystickCircle();

    JImage lcdimage = new JImage(128,64);
    SmallButton lcdimageupdate = new SmallButton("refresh");

    Color yellow=new Color(200, 200, 0);

    public PadPanel(Orc orc)
    {
	super(new GridBagLayout());

	Font smallfont=new Font("Dialog",Font.PLAIN, 9);

	this.orc=orc;

	GridBagConstraints gbc=new GridBagConstraints();
	GridBagConstraints pgbc=new GridBagConstraints();

	///////// ROW ONE
	pgbc.weightx=1; pgbc.weighty=1;  pgbc.fill=GridBagConstraints.BOTH;
	pgbc.anchor=GridBagConstraints.CENTER;

	pgbc.gridx=2; pgbc.gridy=0;
	add(new JLabel("Stick: "), pgbc);
	pgbc.gridx=3;
	add(sticklabel, pgbc);

	pgbc.gridx=2; pgbc.gridy=1;
	add(new JLabel("Menu: "), pgbc);
	pgbc.gridx=3;
	add(menulabel, pgbc);

	pgbc.gridx=2; pgbc.gridy=2;
	add(new JLabel("Stop: "), pgbc);
	pgbc.gridx=3;
	add(stoplabel, pgbc);

	pgbc.gridx=1; pgbc.gridy=0;
	pgbc.gridwidth=1; pgbc.gridheight=2;
	pgbc.weightx=99; pgbc.weighty=99;
	pgbc.insets=new Insets(3, 3, 3, 3);
	add(jc, pgbc);

	pgbc.insets=new Insets(0,0,0,0);
	pgbc.gridy=2;
	add(new JLabel(""),pgbc);

	pgbc.gridx=0; pgbc.gridy=0;
	pgbc.gridwidth=1; pgbc.gridheight=2;
	pgbc.weightx=1; pgbc.weighty=1;
	pgbc.insets=new Insets(3, 3, 3, 3);
	add(lcdimage, pgbc);

	pgbc.insets=new Insets(0,0,0,0);
	pgbc.gridx=0; pgbc.gridy=2;
	pgbc.gridwidth=1; pgbc.gridheight=1;
	pgbc.weightx=1; pgbc.weighty=1;
	pgbc.fill=GridBagConstraints.NONE;
	pgbc.anchor=GridBagConstraints.NORTHEAST;

	add(lcdimageupdate, pgbc);
	lcdimageupdate.addActionListener(new ImageUpdateActionListener());

	setBackground(yellow);

	orc.addUpdateListener(this);

	lcdimage.setImage(orc.lcdRead());

	LCDUpdateThread lut=new LCDUpdateThread();
	lut.start();


    }

    public void orcUpdated(Orc orc)
    {
	int b=orc.padButtonsPoll();

	sticklabel.setText((b&Orc.BUTTON_STICK)>0 ? "1" : "0");
	menulabel.setText((b&Orc.BUTTON_MENU)>0 ? "1" : "0");
	stoplabel.setText((b&Orc.BUTTON_STOP)>0 ? "1" : "0");

	jc.repaint();
    }

    class JoystickCircle extends JComponent
    {
	public static final long serialVersionUID=1001;

	public void paint(Graphics g)
	{
	    int width=getWidth();
	    int height=getHeight();

	    int cx=width/2, cy=height/2;

	    int diam=width<height ? width : height;

	    int joyx=-diam/2*(orc.joyX()-128)/128;
	    int joyy=-diam/2*(orc.joyY()-128)/128;

	    g.setColor(Color.black);
	    g.fillOval(cx-diam/2,cy-diam/2, diam, diam);

	    g.setColor(Color.white);
	    int knobsize=6;
	    g.fillOval(cx-joyx-knobsize/2, cy-joyy-knobsize/2, knobsize, knobsize);
	}

	public Dimension getMaximumSize()
	{
	    return new Dimension(100,100);
	}

	public Dimension getMinimumSize()
	{
	    return new Dimension(60,60);
	}

	public Dimension getPreferredSize()
	{
	    return getMinimumSize();
	}
    }

    public class ImageUpdateActionListener implements ActionListener
    {
	public void actionPerformed(ActionEvent e)
	{
	    lcdimage.setImage(orc.lcdRead());
	}
    }

    class LCDUpdateThread extends Thread
    {
	LCDUpdateThread()
	{
	    setDaemon(true);
	}

	public void run()
	{
	    if (true)
		return;

	    while(true)
		lcdimage.setImage(orc.lcdRead());
	}
    }
}
