package maslab.telemetry;

import maslab.telemetry.*;
import maslab.telemetry.channel.*;
import maslab.util.*;

import java.util.*;

/** Channel for publishing text messages to the BotClient **/
public class JugLoggerPublisher extends LoggerPublisher
{
    TextChannel  channel;

    /** Create a new TextChannel
     * @param name The name of the channel to publish on.
    **/
    public JugLoggerPublisher(String name)
    {
	channel = new TextChannel(name);

	Logger.addPublisher(this);
    }

    public void publishUnconditional(String name, int level, String message)
    {
	long nowTime=System.currentTimeMillis();
	double elapsedTime=(nowTime-Logger.startTime)/1000.0;
	String levelName=Logger.levelToString(level);
	
	channel.publish(StringUtil.padRight(name,20,' ') + 
			StringUtil.padLeft(StringUtil.formatDouble(elapsedTime,3),10,' ') + " " +
			StringUtil.padRight(levelName,10,' ') +
			message + '\n');
    }
}
