package maslab.telemetry.botclient;


import java.util.*;

/** Stores which plugins are default for which types.  I made this a
 * separate class with the intention of adding a mechanism for
 * actually setting defaults.  Right now it's simply the first plugin
 * found. **/
public class DefaultHandlers
{
    HashMap<String,String> defaults;
    PluginController bc;

    public DefaultHandlers(PluginController bc)
    {
	this.bc = bc;
	defaults = new HashMap<String,String>();
	makeDefaults();
    }

    //Returns the default plugin name for handling type
    String get(String type)
    {
	return (String)defaults.get(type);
    }


    void set(String type, String plugin)
    {
	defaults.put(type,plugin);
    }


    void makeDefaults()
    {
	String[] plugin;
	String[] type = bc.getTypes();
	for (int i=0; i<type.length; i++)
	    {
		plugin = bc.getPlugins(type[i]);
		if (plugin != null)
		    defaults.put(type[i],plugin[0]);
	    }

    }


}
