package maslab.telemetry.botclient;


import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/** The JFrame that pops up when a user selects View -> New Channel
 * View within BotClient.  **/
class ManualAdd extends JFrame implements ActionListener
{
    JTextField namefield;
    JComboBox typebox,pluginbox;
    JButton okbutton, cancelbutton;
    BotClient bc;

    static final long serialVersionUID = 1001;

    public ManualAdd(BotClient bc)
    {
	this.bc = bc;
	setTitle("Add a Viewer");
	setBackground(Color.lightGray);
	
	GridBagLayout gb = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	getContentPane().setLayout(gb);

	JLabel label = new JLabel("Channel Name");
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.anchor = GridBagConstraints.SOUTHWEST;
	c.fill = GridBagConstraints.NONE;
	c.insets = new Insets(5,15,0,15);
	gb.setConstraints(label,c);
	getContentPane().add(label);

	namefield = new JTextField();
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.CENTER;
	gb.setConstraints(namefield,c);
	getContentPane().add(namefield);

	label = new JLabel("Channel Type");
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.SOUTHWEST;
	c.insets = new Insets(5,15,0,15);
	gb.setConstraints(label,c);
	getContentPane().add(label);

	typebox = new JComboBox(bc.getTypes());
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 1;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.CENTER;
	gb.setConstraints(typebox,c);
	getContentPane().add(typebox);
	typebox.addActionListener(this);

	label = new JLabel("Plugin");
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 2;
	c.gridy = 0;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.SOUTHWEST;
	c.insets = new Insets(5,15,0,15);
	gb.setConstraints(label,c);
	getContentPane().add(label);


	String[] plugins = bc.getPlugins((String)typebox.getSelectedItem());
	for (int i=0; i<plugins.length; i++)
	    plugins[i] = PluginController.shortName(plugins[i]);
	pluginbox = new JComboBox(plugins);
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 2;
	c.gridy = 1;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.NONE;
	c.anchor = GridBagConstraints.CENTER;
	gb.setConstraints(pluginbox,c);
	getContentPane().add(pluginbox);
	pluginbox.addActionListener(this);


	JPanel pan = new JPanel();
    	c.gridwidth = 3;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 2;
	c.weightx = 0;
	c.weighty = 0;
	c.fill = GridBagConstraints.BOTH;
	c.anchor = GridBagConstraints.CENTER;
	gb.setConstraints(pan,c);
	getContentPane().add(pan);

	gb = new GridBagLayout();
	pan.setLayout(gb);
	

	okbutton = new JButton("OK");
	c.gridwidth = 1;
	c.gridheight = 1;
	c.gridx = 0;
	c.gridy = 0;
	c.weightx = 1;
	c.insets = new Insets(5,5,5,5);
	c.anchor = GridBagConstraints.CENTER;
	c.fill = GridBagConstraints.NONE;
	gb.setConstraints(okbutton,c);
	pan.add(okbutton);
	okbutton.addActionListener(this);

	cancelbutton = new JButton("Cancel");
	c.gridheight = 1;
	c.gridwidth = 1;
	c.gridx = 1;
	c.gridy = 0;
	c.insets = new Insets(5,5,5,5);
	c.anchor = GridBagConstraints.CENTER;
	c.fill = GridBagConstraints.NONE;
	c.weightx = 1;
	gb.setConstraints(cancelbutton,c);
	pan.add(cancelbutton);
	cancelbutton.addActionListener(this);
	
	pack();
	setVisible(true);
	

    }

    public void actionPerformed(ActionEvent e)
    {
	if (e.getSource() == typebox)
	    {
		pluginbox.removeAllItems();
		String[] plugins = bc.getPlugins((String)typebox.getSelectedItem());
		for (int i=0; i<plugins.length; i++)
		    {
			plugins[i] = PluginController.shortName(plugins[i]);
			pluginbox.addItem(plugins[i]);
		    }

	    }

	if (e.getSource() == cancelbutton)
	    setVisible(false);

	if (e.getSource() == okbutton)
	    {
		if (namefield.getText().equals(""))
		    {
			JOptionPane.showMessageDialog(this,"You must enter a channel name.");
			return;
		    }
		bc.newHandler(namefield.getText(),(String)typebox.getSelectedItem(),(String)pluginbox.getSelectedItem());
		setVisible(false);
	    }
    }

}
