package maslab.telemetry.botclient;

import maslab.util.*;

import java.util.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.*;
import java.lang.reflect.*;

class PluginController
{
    // Keys are type strings, ie "text", "video" 
    //Values are Sets of Classes that implement the Plugin interface.
    HashMap<String, HashSet<Class>> types;
    DefaultHandlers dh;

    // Keys are Plugins, values are HashSets of channel names (strings)
    HashMap<Plugin, HashSet<String>> subscriptions;

    public static Logger log=new Logger("PluginController");    

    public PluginController()
    {
	types = new HashMap<String,HashSet<Class>>();

	HashSet<String> names = new HashSet<String>();
	names.add("maslab.telemetry.botclient.TextPlugin");
	names.add("maslab.telemetry.botclient.ImagePlugin");
	names.add("maslab.telemetry.botclient.VectorPlugin");
	names.add("maslab.telemetry.botclient.ScopePlugin");
	loadPlugins(names);
	dh = new DefaultHandlers(this);
    }

    public static String shortName(String pluginName)
    {
	int c = pluginName.lastIndexOf(".");
	if (c == -1)
	    return pluginName;
	else
	    return pluginName.substring(c+1,pluginName.length());
	
    }


    void loadPlugins(HashSet names)
    {
	log.verbose("Loading plugins...");
	
	Iterator i = names.iterator();
	while (i.hasNext())
	    {
		String name = (String)i.next();

		try{
		    Class c = Class.forName(name);
		    String typeStrings = (String)c.getField("types").get(null);
		    log.verbose("Loaded plugin " + shortName(name) + " for types " + typeStrings);
		    
		    StringTokenizer st = new StringTokenizer(typeStrings,",");
		    while (st.hasMoreTokens())
			{
			    HashSet<Class> s;
			    String t = st.nextToken();
			    if (types.containsKey(t))
				s = types.get(t);
			    else
				{
				    s = new HashSet<Class>();
				    types.put(t,s);
				}
			    s.add(c);
			}
		}
		catch(Exception e){
		    log.log(Logger.WARN,"Error loading plugin " + name,e);
		}
	    }
    }
    
    HashSet<String> searchPlugins(File dir)
    {
	if (!dir.isDirectory())
	    {
		log.error("Error opening plugins directory.");
		return null;
	    }

	HashSet<String> result = new HashSet<String>();

	String[] files = dir.list();
	for (int i=0; i<files.length; i++)
	    {
		if (files[i].endsWith(".class") && files[i].indexOf('$')==-1)
		    {
			int j = files[i].indexOf(".class");
			String name = files[i].substring(0,j);
			result.add(name);
		    }
	    }
	return result;
    }


    //Will return null if there isn't one
    public String getDefaultPlugin(String type)
    {
	return dh.get(type);
    }

    public String[] getPlugins(String type)
    {
	if (!types.containsKey(type))
	    return null;

	Set s = (Set)types.get(type);
	String[] result = new String[s.size()];
	Iterator i = s.iterator();
	int count = 0;
	while (i.hasNext())
	    result[count++] = ((Class)i.next()).getName();
	    
	return result;
    }

    public String[] getTypes()
    {
	Set s = types.keySet();
	Iterator i = s.iterator();
	String[] result = new String[s.size()];
	int count=0;
	while (i.hasNext())
	    result[count++] = (String)i.next();
	return result;
    }


    // Instantiate a new handler with plugin named @pluginName, and
    // place it within @frame
    public Plugin newHandler(String pluginName,JInternalFrame frame)
    {
	Class c;

	try{
	    c = Class.forName(pluginName);
	}
	catch(ClassNotFoundException e){
	    c = null;
	}

	try{
	    if (c == null)
		c = Class.forName("maslab.telemetry.botclient." + pluginName);

	    Constructor con = c.getConstructor(new Class[] {JInternalFrame.class});

	    frame.setClosable(true);
	    frame.setIconifiable(true);
	    Plugin p = (Plugin)con.newInstance(new Object[] {frame});

	    return p;
	}
	catch(Exception e){
	    log.log(Logger.WARN,"Unable to instantiate plugin " + pluginName,e);
	    return null;
	}
	    
    }





}


