package maslab.test;
 
import java.net.*;
import java.io.*;
import java.awt.image.*;
import java.awt.*;
import java.awt.color.ColorSpace;
import java.util.*;
import java.util.concurrent.*;

import maslab.util.*;
import maslab.orc.*;

/** An application used for internal testing. **/
public class AnalogTest
{
    public static void main(String[] args)
    {
	Orc orc;

	try {
	    orc=new Orc();
	} catch (Exception ex) {
	    return;
	}

	GetOpt opts=new GetOpt();
	opts.parse(args);
	ArrayList<String> extraArgs=opts.getExtraArgs();

	orc.setCacheLifetime(-1);

	int SIZE=100;

	while(true)
	    {
		double max, min;
		double[] data=new double[SIZE];

		max=0;
		min=5;

		for (int i=0;i<SIZE;i++)
		    {
			double v=orc.analogRead(8);
			data[i]=v;

			max=Math.max(max, v);
			min=Math.min(min, v);
		    }

		Arrays.sort(data);

		double offset=0.05920500;

		double maxcur=(max-offset)/0.18;
		double mincur=(min-offset)/0.18;
		double medcur=(data[SIZE>>1]-offset)/0.18;
		System.out.println("max: "+max+"\t min "+min+"\t cur ");
		System.out.println("maxcur: "+StringUtil.formatDouble(maxcur*1000,0));
		System.out.println("mincur: "+StringUtil.formatDouble(mincur*1000,0));
		System.out.println("medcur: "+StringUtil.formatDouble(medcur*1000,0));
	    }

    }
}
