package maslab.util;

import java.util.*;
import java.util.zip.*;
import java.io.*;
import maslab.util.*;

/** Extracts resources from a zip or jar file **/
public class ZipExtractor
{
    static final int BUFFER_SIZE = 100000;
    HashMap<String, Integer> htSizes;
    String zipfile;

    public ZipExtractor(String zipfile) throws IOException
    {
	this.zipfile = zipfile;
	htSizes = new HashMap<String, Integer>();
	ZipFile zf=new ZipFile(zipfile);
	Enumeration e=zf.entries();
	while (e.hasMoreElements()) {
	    ZipEntry ze=(ZipEntry)e.nextElement();
	    htSizes.put(ze.getName(),new Integer((int)ze.getSize()));
	}
	zf.close();
    }


    public byte[] getResource(String name) throws IOException
    {
	FileInputStream fis = new FileInputStream(zipfile);
	BufferedInputStream bis = new BufferedInputStream(fis);
	ZipInputStream zis = new ZipInputStream(bis);

	ZipEntry ze = null;
	while ((ze = zis.getNextEntry()) != null)
	    {
		if (ze.getName().equals(name))
		    {
			int size = ((Integer)htSizes.get(name)).intValue();
			int count = 0;
			byte[] result = new byte[size];
			while (count < size)
			    count += zis.read(result,count,size-count);
			return result;
		    }
	    }
	return null;
    }

    public void saveResource(String name, String filename) throws IOException
    {
	byte[] data = getResource(name);
	FileOutputStream fos = new FileOutputStream(filename);
	fos.write(data);
	fos.close();
    }

}
