package maslab.vis;

import maslab.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.*;

/** A single point. **/
public class VisPoint extends VisObject
{
    public double size=6; // in pixels
    public Color color=Color.blue;

    public double x, y;

    public VisPoint(Color c, double size, double x, double y)
    {
	this.color=c;
	this.size=size;
	this.x=x;
	this.y=y;
    }

    public void paint(VisCanvas vc, Graphics2D g, BufferedImage bi)
    {
	double scale=vc.getScale();

	double sz=size/scale;

	g.setColor(color);

	Ellipse2D.Double e=new Ellipse2D.Double(0,0,0,0);

	e.x=x-sz/2;
	e.y=y-sz/2;
	e.width=sz;
	e.height=sz;
	g.fill(e);
    }
}
