package maslab.vis;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

/** Sample code, demonstrating how to create a JFrame and add a
 * VisCanvas to it. **/
public class Visualization extends JFrame
{
    VisCanvas vcanv;

    final static long serialVersionUID=1001;

    public Visualization()
    {
	super("Vis");

	vcanv=new VisCanvas();

	getContentPane().setLayout(new BorderLayout());
	getContentPane().add(vcanv, BorderLayout.CENTER);

	setSize(400,300);

	addKeyListener(new MyKeyListener());
	setVisible(true);
    }

    public VisCanvas getVisCanvas()
    {
	return vcanv;
    }

    class MyKeyListener extends KeyAdapter
    {
	public void keyPressed(KeyEvent e)
	{
	    switch(e.getKeyChar())
		{
		default:
		    vcanv.handleKeyPress(e);
		}

	    repaint();
	}
    }

    public static void main(String[] args)
    {
	Visualization v=new Visualization();
	
    }
}
