/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.util.ArrayList;
import java.util.ListIterator;
import maslab.data.ClockEventSource;

public class Clock {
    double timeDialation = 1.0;
    double systemTimeOffset = 0.0;
    double eventTime = 0.0;
    ArrayList<ClockEventSource> eventSources = new ArrayList();
    boolean timeIsUnmetered = false;
    boolean started = false;
    EventThread eventThread;

    public Clock() {
        this(1.0);
        this.start();
    }

    public Clock(double timeDialation) {
        this.timeDialation = timeDialation;
        if (timeDialation <= 0.0) {
            this.timeIsUnmetered = true;
        }
        this.eventThread = new EventThread();
    }

    public Thread getEventThread() {
        return this.eventThread;
    }

    public void start() {
        this.systemTimeOffset = (double)System.currentTimeMillis() / 1000.0;
        this.eventThread.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventSource(ClockEventSource source) {
        ArrayList<ClockEventSource> arrayList = this.eventSources;
        synchronized (arrayList) {
            this.eventSources.add(source);
            this.eventSources.notifyAll();
        }
    }

    public void forceRealtime() {
        this.timeDialation = 1.0;
        this.timeIsUnmetered = false;
    }

    public double getTime() {
        if (!this.started) {
            return 0.0;
        }
        if (!this.timeIsUnmetered) {
            return ((double)System.currentTimeMillis() / 1000.0 - this.systemTimeOffset) * this.timeDialation;
        }
        return this.eventTime;
    }

    public double getWallTime() {
        return (double)System.currentTimeMillis() / 1000.0 - this.systemTimeOffset;
    }

    public void sleepUntilTime(double time) {
        this.sleep(time - this.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(double ms) {
        if (this.timeIsUnmetered || !this.started) {
            SleepEventSource ses;
            SleepEventSource sleepEventSource = ses = new SleepEventSource(this.getTime() + ms);
            synchronized (sleepEventSource) {
                this.addEventSource(ses);
                try {
                    ses.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            return;
        }
        double sleepms = ms / this.timeDialation;
        try {
            if (sleepms > 0.0) {
                Thread.sleep((int)sleepms);
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    class SleepEventSource
    implements ClockEventSource {
        double goalTime;

        SleepEventSource(double goalTime) {
            this.goalTime = goalTime;
        }

        public double timeOfNextEvent() {
            return this.goalTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeChanged(double theTime) {
            if (theTime < this.goalTime) {
                return;
            }
            this.goalTime = -1.0;
            SleepEventSource sleepEventSource = this;
            synchronized (sleepEventSource) {
                this.notifyAll();
            }
        }
    }

    class EventThread
    extends Thread {
        EventThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                double nextEventTime = Double.POSITIVE_INFINITY;
                ArrayList<ClockEventSource> arrayList = Clock.this.eventSources;
                synchronized (arrayList) {
                    while (Clock.this.eventSources.size() == 0) {
                        try {
                            Clock.this.eventSources.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    ListIterator<ClockEventSource> li = Clock.this.eventSources.listIterator(0);
                    while (li.hasNext()) {
                        ClockEventSource source = li.next();
                        double thisEventTime = source.timeOfNextEvent();
                        if (thisEventTime < 0.0) {
                            li.remove();
                            continue;
                        }
                        nextEventTime = Math.min(thisEventTime, nextEventTime);
                    }
                }
                Clock.this.eventTime = nextEventTime;
                if (!Clock.this.timeIsUnmetered) {
                    Clock.this.sleepUntilTime(Clock.this.eventTime);
                }
                Clock.this.eventTime = Math.max(Clock.this.eventTime, Clock.this.getTime());
                arrayList = Clock.this.eventSources;
                synchronized (arrayList) {
                    for (ClockEventSource source : Clock.this.eventSources) {
                        source.timeChanged(Clock.this.eventTime);
                    }
                }
            }
        }
    }
}

