/*
 * Decompiled with CFR 0.152.
 */
package maslab.data;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import maslab.data.DataEvent;
import maslab.data.DataSource;
import maslab.util.Logger;

public class DataLogReader {
    Parser pchn;
    Parser plog;
    Logger log = new Logger(this);
    HashMap<String, DataSource> dataSources = new HashMap();
    HashMap<String, Boolean> enabledChannels;

    public DataSource getDataSource(String channel) {
        return this.dataSources.get(channel);
    }

    public DataLogReader(String logspecification) throws IOException {
        if (logspecification.endsWith(".")) {
            logspecification = logspecification.substring(0, logspecification.length() - 1);
        }
        int colonpos = logspecification.indexOf(58);
        String path = logspecification;
        if (colonpos >= 0) {
            this.enabledChannels = new HashMap();
            String[] fields = logspecification.split(":");
            path = fields[0];
            for (int i = 1; i < fields.length; ++i) {
                String f = fields[i].toUpperCase();
                if (fields[i].charAt(0) == '~') {
                    this.enabledChannels.put(f.substring(1), false);
                    continue;
                }
                this.enabledChannels.put(f, true);
            }
            if (this.enabledChannels.size() == 0) {
                this.log.warn("No channels enabled!");
            }
        }
        this.pchn = new Parser(path + ".chn");
        this.plog = new Parser(path + ".log");
        while (this.pchn.parseNext()) {
            if (this.pchn.fields.length < 2) {
                System.out.println("Not enough fields [" + this.pchn.getPath() + ":" + this.pchn.getLineNumber() + "] " + this.pchn.getLine());
                continue;
            }
            String name = this.pchn.fields[0];
            String cls = this.pchn.fields[1];
            String data = this.pchn.data;
            try {
                Class<?> theclass = ClassLoader.getSystemClassLoader().loadClass(cls);
                Constructor<?> theconstructor = theclass.getConstructor(String.class);
                DataSource datasource = (DataSource)theconstructor.newInstance(data);
                datasource.setParameters(data);
                this.dataSources.put(name, datasource);
            }
            catch (Exception ex) {
                this.log.error("Unable to create data source: ", ex);
            }
        }
    }

    public SourceEventPair next() throws IOException {
        while (this.plog.parseNext()) {
            DataEvent event;
            DataSource source;
            if (this.plog.fields.length < 2) {
                System.out.println("Not enough fields [" + this.plog.getPath() + ":" + this.plog.getLineNumber() + "] " + this.plog.getLine());
                continue;
            }
            double timeStamp = Double.parseDouble(this.plog.fields[0]);
            String channelName = this.plog.fields[1];
            Boolean b = this.enabledChannels == null ? true : this.enabledChannels.get(channelName);
            if (b == null) {
                this.log.warn("Logger is dropping events with channel name =" + channelName);
                this.enabledChannels.put(channelName, false);
                continue;
            }
            if (!b.booleanValue() || (source = this.dataSources.get(channelName)) == null || (event = source.stringToEvent(timeStamp, this.plog.data)) == null) continue;
            return new SourceEventPair(source, event);
        }
        return null;
    }

    class Parser {
        BufferedReader ins;
        String l;
        String path;
        public String[] fields;
        public String data;
        int linenumber = 0;

        public Parser(String path) throws IOException {
            this.path = path;
            this.ins = new BufferedReader(new FileReader(path));
        }

        public boolean parseNext() throws IOException {
            int colonpos;
            do {
                this.l = this.ins.readLine();
                ++this.linenumber;
                if (this.l != null) continue;
                this.ins.close();
                return false;
            } while (this.l.length() < 1 || this.l.charAt(0) == '#' || (colonpos = this.l.indexOf(58)) < 0);
            String header = this.l.substring(0, colonpos);
            this.fields = header.split("\\s+");
            this.data = this.l.substring(colonpos + 1).trim();
            return true;
        }

        public int getLineNumber() {
            return this.linenumber;
        }

        public String getLine() {
            return this.l;
        }

        public String getPath() {
            return this.path;
        }
    }

    public class SourceEventPair {
        public DataSource source;
        public DataEvent event;

        public SourceEventPair(DataSource source, DataEvent event) {
            this.source = source;
            this.event = event;
        }
    }
}

