/*
 * Decompiled with CFR 0.152.
 */
package maslab.geom;

import Jama.Matrix;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import maslab.geom.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPoint2D
implements Cloneable,
Serializable {
    protected double x;
    protected double y;
    public static final GPoint2D ORIGIN = new GPoint2D(0.0, 0.0);
    static final long serialVersionUID = 1001L;

    public GPoint2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public GPoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double distanceTo(GPoint2D p) {
        return Math.sqrt((p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y));
    }

    public double squaredDistanceTo(GPoint2D p) {
        return (p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y);
    }

    public GPoint2D transform(double dx, double dy, double theta) {
        GPoint2D np = new GPoint2D();
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        np.x = this.x * c - this.y * s + dx;
        np.y = this.x * s + this.y * c + dy;
        return np;
    }

    public GPoint2D transform(Matrix P) {
        if (P.getColumnDimension() == 1) {
            return this.transform(P.get(0, 0), P.get(1, 0), P.get(2, 0));
        }
        GPoint2D np = new GPoint2D();
        np.x = this.x * P.get(0, 0) + this.y * P.get(0, 1) + P.get(0, 2);
        np.y = this.x * P.get(1, 0) + this.y * P.get(1, 1) + P.get(1, 2);
        return np;
    }

    public static ArrayList<GPoint2D> transform(ArrayList<GPoint2D> pin, Matrix Pin) {
        ArrayList<GPoint2D> pout = new ArrayList<GPoint2D>();
        Matrix P = GeomUtil.transformationMatrix31(Pin);
        double dx = P.get(0, 0);
        double dy = P.get(1, 0);
        double c = Math.cos(P.get(2, 0));
        double s = Math.sin(P.get(2, 0));
        for (GPoint2D p : pin) {
            GPoint2D np = new GPoint2D();
            np.x = p.x * c - p.y * s + dx;
            np.y = p.x * s + p.y * c + dy;
            pout.add(np);
        }
        return pout;
    }

    public GPoint2D scale(double s) {
        return new GPoint2D(this.x * s, this.y * s);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }
}

