/*
 * Decompiled with CFR 0.152.
 */
package maslab.geom;

import Jama.Matrix;
import maslab.geom.GPoint2D;

public class GeomUtil {
    public static Matrix transformationMatrix33(Matrix T) {
        if (T.getColumnDimension() == 3 && T.getRowDimension() == 3) {
            return T.copy();
        }
        assert (T.getRowDimension() == 3 && T.getColumnDimension() == 1);
        return GeomUtil.transformationMatrix33(T.get(0, 0), T.get(1, 0), T.get(2, 0));
    }

    public static Matrix transformationMatrix33(double dx, double dy, double dt) {
        Matrix P = new Matrix(3, 3);
        P.set(0, 0, Math.cos(dt));
        P.set(0, 1, -Math.sin(dt));
        P.set(0, 2, dx);
        P.set(1, 0, Math.sin(dt));
        P.set(1, 1, Math.cos(dt));
        P.set(1, 2, dy);
        P.set(2, 2, 1.0);
        return P;
    }

    public static Matrix transformationMatrix31(Matrix P) {
        if (P.getColumnDimension() == 1 && P.getRowDimension() == 3) {
            return P;
        }
        assert (P.getRowDimension() == 3 && P.getColumnDimension() == 3);
        Matrix S = new Matrix(3, 1);
        S.set(0, 0, P.get(0, 2));
        S.set(1, 0, P.get(1, 2));
        S.set(2, 0, Math.atan2(P.get(1, 0), P.get(0, 0)));
        return S;
    }

    public static Matrix transformationMultiply31(Matrix a, Matrix b) {
        return GeomUtil.transformationMultiply31(a, b, new Matrix(3, 1));
    }

    public static Matrix transformationMultiply31(Matrix a, Matrix b, Matrix r) {
        if (r == null) {
            r = new Matrix(3, 1);
        }
        Matrix Ta = GeomUtil.transformationMatrix31(a);
        Matrix Tb = GeomUtil.transformationMatrix31(b);
        double xa = Ta.get(0, 0);
        double ya = Ta.get(1, 0);
        double ta = Ta.get(2, 0);
        double xb = Tb.get(0, 0);
        double yb = Tb.get(1, 0);
        double tb = Tb.get(2, 0);
        double s = Math.sin(ta);
        double c = Math.cos(ta);
        r.set(0, 0, c * xb - s * yb + xa);
        r.set(1, 0, s * xb + c * yb + ya);
        r.set(2, 0, ta + tb);
        return r;
    }

    public static Matrix transformationMultiply33(Matrix a, Matrix b) {
        Matrix Ta = GeomUtil.transformationMatrix33(a);
        Matrix Tb = GeomUtil.transformationMatrix33(b);
        Matrix T = Ta.times(Tb);
        return GeomUtil.transformationMatrix33(T);
    }

    public static Matrix transformationInverse31(Matrix a) {
        return GeomUtil.transformationInverse31(a, new Matrix(3, 1));
    }

    public static Matrix transformationInverse31(Matrix a, Matrix r) {
        if (r == null) {
            r = new Matrix(3, 1);
        }
        Matrix Ta = GeomUtil.transformationMatrix31(a);
        double xa = Ta.get(0, 0);
        double ya = Ta.get(1, 0);
        double ta = Ta.get(2, 0);
        double s = Math.sin(ta);
        double c = Math.cos(ta);
        r.set(0, 0, -s * ya - xa * c);
        r.set(1, 0, -c * ya + xa * s);
        r.set(2, 0, -ta);
        return r;
    }

    public static Matrix relativeTo(Matrix a, Matrix b) {
        Matrix m = new Matrix(3, 1);
        GPoint2D p = new GPoint2D(a.get(0, 0) - b.get(0, 0), a.get(1, 0) - b.get(1, 0));
        p = p.transform(0.0, 0.0, -b.get(2, 0));
        m.set(0, 0, p.getX());
        m.set(1, 0, p.getY());
        m.set(2, 0, a.get(2, 0) - b.get(2, 0));
        return m;
    }

    public static void main(String[] args) {
        Matrix M00_0 = new Matrix(3, 1);
        Matrix M10_0 = new Matrix(3, 1);
        M10_0.set(0, 0, 1.0);
        Matrix M10_90 = new Matrix(3, 1);
        M10_90.set(0, 0, 1.0);
        M10_90.set(2, 0, 1.5707963267948966);
        GeomUtil.relativeTo(M00_0, M10_0).transpose().print(5, 5);
        GeomUtil.relativeTo(M00_0, M10_90).transpose().print(5, 5);
    }
}

